/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.nimlimited;

import java.util.Arrays;
import java.util.LinkedList;
import sk.lenhardt.game.Position;

public class LimitedNimPosition
extends Position {
    private int n;
    private int[] moves;

    public LimitedNimPosition(int n, int[] moves) {
        this.n = n;
        this.moves = moves;
    }

    public LimitedNimPosition(int n, int k) {
        this.n = n;
        this.moves = new int[k];
        for (int i = 0; i < k; ++i) {
            this.moves[i] = i + 1;
        }
    }

    public boolean isFinal() {
        return this.n == 0;
    }

    public Position[] getAllPossibleMoves() {
        LinkedList<LimitedNimPosition> ret = new LinkedList<LimitedNimPosition>();
        for (int i = 0; i < this.moves.length; ++i) {
            if (this.n - this.moves[i] < 0) continue;
            ret.add(new LimitedNimPosition(this.n - this.moves[i], this.moves));
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LimitedNimPosition)) {
            return false;
        }
        LimitedNimPosition pos = (LimitedNimPosition)o;
        return pos.n == this.n && pos.moves == this.moves;
    }

    public int hashCode() {
        int ret = this.n ^ Arrays.hashCode(this.moves);
        return ret;
    }
}

