/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.sum;

import java.util.LinkedList;
import sk.lenhardt.game.Position;
import sk.lenhardt.sum.WTIAPosition;

public class OrdinarySumPosition {
    public Position a;
    public Position b;

    public OrdinarySumPosition(Position a, Position b) {
        this.a = a;
        this.b = b;
    }

    public Position[] getAllPossibleMoves() {
        int i;
        if (this.isFinal()) {
            return new Position[0];
        }
        Position[] aMoves = this.a.getAllPossibleMoves();
        Position[] bMoves = this.b.getAllPossibleMoves();
        LinkedList<OrdinarySumPosition> ret = new LinkedList<OrdinarySumPosition>();
        for (i = 0; i < aMoves.length; ++i) {
            ret.add(new OrdinarySumPosition(aMoves[i], this.b));
        }
        for (i = 0; i < bMoves.length; ++i) {
            ret.add(new OrdinarySumPosition(this.a, bMoves[i]));
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public int getGrundyNumber() {
        return this.a.getGrundyNumber() ^ this.b.getGrundyNumber();
    }

    public boolean isLosing() {
        return this.getGrundyNumber() == 0;
    }

    public boolean isFinal() {
        return this.a.isFinal() && this.b.isFinal();
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WTIAPosition)) {
            return false;
        }
        WTIAPosition pos = (WTIAPosition)o;
        return this.a.equals(pos.a) && this.b.equals(pos.b) || this.a.equals(pos.b) && this.b.equals(pos.a);
    }
}

