/*
 * BoardPosition.java
 *
 * Created on Štvrtok, 2007, február 22, 21:10
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.board;

import sk.lenhardt.game.Position;
import java.util.Arrays;
import java.util.LinkedList;
/**
 *
 * @author rasto
 */
public class BoardPosition extends Position{
    
    // can move as much as he wants
    private static final int INF = -3;
    
    public static final int KNIGHT = 0;
    private int[] moveXKnight={-1,-2, 1,-2};
    private int[] moveYKnight={-2,-1,-2, 1};
    
    public static final int QUEEN = 1;
    private int[] moveXQueen={0  ,INF,INF};
    private int[] moveYQueen={INF,0  ,INF};
    
    public static final int ROOK = 2;
    private int[] moveXRook={0  ,INF};
    private int[] moveYRook={INF,0  };
    
    public static final int KING = 3;
    private int[] moveXKing={0 ,-1,-1};
    private int[] moveYKing={-1,0 ,-1};
    
    
    private int[] moveX;    
    private int[] moveY;
    private int posX;
    private int posY;
    private int limit;
    
    /** Creates a new instance of BoardPosition */
    public BoardPosition(int figure, int posX, int posY, int limit) {
        this.posX = posX;
        this.posY = posY;
        this.limit = limit;
        
        if (figure==KNIGHT) {
            moveX=moveXKnight;
            moveY=moveYKnight;
        } else if (figure==QUEEN) {
            moveX=moveXQueen;
            moveY=moveYQueen;
        } else if (figure==ROOK) {
            moveX=moveXRook;
            moveY=moveYRook;
        } else if (figure==KING) {
            moveX=moveXKing;
            moveY=moveYKing;
        } else {
            moveX=new int[0];
            moveY=new int[0];
        }
    }
/** Creates a new instance of BoardPosition */
    public BoardPosition(int figure, int posX, int posY) {
        this(figure, posX, posY, -1);
    }    
    public BoardPosition(int[] moveX, int[] moveY, int posX, int posY,int limit) {
        this.posX = posX;
        this.posY = posY;
        this.moveX = moveX;
        this.moveY = moveY;    
        this.limit = limit;
    }
    public BoardPosition(int[] moveX, int[] moveY, int posX, int posY) {
        this(moveX, moveY, posX, posY, -1);
    }
    
    private boolean isLimit(int x, int y) {
        if (limit==-1) return true;
        else {
            if (x>=limit||y>=limit) return false;
            else return true;
        }        
    }
    
    public boolean isFinal() {
        Position[] poss = getAllPossibleMoves();
        if (poss==null||poss.length==0) return true;
        return false;
    }    
    
    public Position[] getAllPossibleMoves() {
        LinkedList ret= new LinkedList(); 
        for (int i=0;i<moveX.length;i++) {
            int x = moveX[i];
            int y = moveY[i];
            if (x!=INF&&y!=INF) {
                if (posX+x>=0&&posY+y>=0 && isLimit(posX+x, posY+y)) {
                    ret.add(new BoardPosition(moveX,moveY,posX+x, posY+y,limit));                    
                }
            } else if (x==INF&&y==INF) {
                int maxim = posX < posY ? posX : posY;
                for (int k=-maxim;k<0;k++) {
                    if (posX+k>=0 && posY+k>=0 && isLimit(posX+k, posY+k)) {
                        ret.add(new BoardPosition(moveX, moveY, posX+k,posY+k,limit));
                    }
                }
            } else if (x==INF&&y!=INF) {
                for (int k=-posX;k<0;k++) {
                    if (posX+k>=0 && posY+y>=0 && isLimit(posX+k, posY+y)) {
                        ret.add(new BoardPosition(moveX, moveY, posX+k,posY+y,limit));
                    }
                }
            } else if (x!=INF&&y==INF) {
                for (int k=-posY;k<0;k++) {
                    if (posX+x>=0 && posY+k>=0 && isLimit(posX+x, posY+k)) {
                        ret.add(new BoardPosition(moveX, moveY, posX+x,posY+k,limit));
                    }
                }
            }         
        }
        return (Position[])ret.toArray(new Position[ret.size()]);    
    }
    
    public boolean equals(Object o) {
        if (! (o instanceof BoardPosition )) return false;
        BoardPosition pos = (BoardPosition)o;
        if (pos.posX==this.posX&&pos.posY==this.posY&&pos.moveX.equals(this.moveX)&&pos.moveY.equals(this.moveY)&&pos.limit==this.limit) return true;
        return false;
    }
    
    public int hashCode() {
        return Arrays.hashCode(moveX) ^ Arrays.hashCode(moveY) ^ (posX ^ posY);                
    }
}
