/*
 * Position.java
 *
 * Created on Streda, 2006, október 25, 15:45
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.game;

/**
 *
 * @author rasto
 */
public abstract class Position {
    
    public abstract boolean isFinal();        
    
    public abstract Position[] getAllPossibleMoves();
    
    public boolean isWinning() {
        return WLAlgorithm.isWinning(this);
    }
    
    public boolean isLosing() {
        return WLAlgorithm.isLosing(this);
    }
    
    public int getGrundyNumber() {
        return GrundyNumbersAlgorithm.getGrundyNumber(this);
    }
    
    public int getWTIANumber() {
        return WTIAAlgorithm.getWTIANumber(this);
    }
    
    public int getRemoteness() {
        return RemotenessAlgorithm.getRemoteness(this);        
    }
    
    public int getSuspense() {
        return SuspenseAlgorithm.getSuspense(this);
    }
    
    public void draw(PositionVisitor v) {
        v.draw(this);
    }
}
