/*
 * WTIAAlgorithm.java
 *
 * Created on Streda, 2006, október 25, 17:15
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.game;

import java.util.HashMap;
/**
 *
 * @author rasto
 */

public class WTIAAlgorithm {
    /* Winner Takes It All*/    
    
    public static final int SUPER_LOOSING = -2;
    public static final int SUPER_WINNING = -1;
    
    private static HashMap cache = new HashMap();
    
    public static int getWTIANumber(Position pos) {
        if (cache.containsKey(pos)) {
            return ((Integer)cache.get(pos)).intValue();
        }
        
        Position[] moves = pos.getAllPossibleMoves();
        if (pos.isFinal()) {
                cache.put(pos, Integer.valueOf(SUPER_LOOSING));
                return SUPER_LOOSING;        
        }        
        //boolean[] nimbers= new boolean[moves.length+1];
        HashMap nimbers = new HashMap();
        
        for (int i=0;i<moves.length;i++) {
            int posNumber = moves[i].getWTIANumber();
            if (posNumber==SUPER_LOOSING) {
                cache.put(pos, Integer.valueOf(SUPER_WINNING));
                return SUPER_WINNING;
            } else if (posNumber!=SUPER_WINNING) {
                //nimbers[posNumber]=true;
                nimbers.put(posNumber,true);                
            }
        }
        int ret=0;        
        //while (nimbers[ret]==true) ret++;
        while (nimbers.containsKey(ret)) ret++;
        
        cache.put(pos, Integer.valueOf(ret));
        return ret;
    }
   
}
