/*
 * OrdinarySumPosition.java
 *
 * Created on Nedeľa, 2007, apríl 1, 11:09
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.sum;

import sk.lenhardt.game.Position;
import java.util.LinkedList;

/**
 *
 * @author rasto
 */
public class OrdinarySumPosition extends Position{
    
    public Position a, b;
    
    /** Creates a new instance of OrdinarySumPosition */
    public OrdinarySumPosition(Position a,Position b) {
        this.a = a;
        this.b = b;
    }
    
    public Position[] getAllPossibleMoves() {
        if (isFinal()) return new Position[0];
        Position[] aMoves = a.getAllPossibleMoves();
        Position[] bMoves = b.getAllPossibleMoves();
        LinkedList ret= new LinkedList();                
        for (int i=0;i<aMoves.length;i++) {
            ret.add(new OrdinarySumPosition(aMoves[i],b));            
        }
        for (int i=0;i<bMoves.length;i++) {
            ret.add(new OrdinarySumPosition(a,bMoves[i]));            
        }        
        return (Position[])ret.toArray(new Position[ret.size()]);                
    }
    
    public int getGrundyNumber() {
        return a.getGrundyNumber()^b.getGrundyNumber();
    }
    
    public boolean isLosing() {
        return (getGrundyNumber()==0);
    }
    
    public boolean isFinal() {
        return a.isFinal()&&b.isFinal();
    }
    
    public int hashCode() {
        return a.hashCode()^b.hashCode();
    }
    
    public boolean equals(Object o) {
        if (! (o instanceof WTIAPosition)) return false;
        WTIAPosition pos = (WTIAPosition)o;
        return (this.a.equals(pos.a)&&this.b.equals(pos.b))||(this.a.equals(pos.b)&&this.b.equals(pos.a));
    }
    
}
