/*
 * Decompiled with CFR 0.152.
 */
package james;

import android.util.Base64;
import android.util.Log;
import info.guardianproject.f5android.Extract;
import james.DCTSteganography;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;

public class DCTStegoCERep
implements DCTSteganography {
    private final double alpha = 0.8;
    private final double beta = 0.3333333333333333;
    private final int maxLenghtBits = 16;
    private final int maxCoeffs = 50000000;
    private final int maxCoeffRange = 127;
    private final int rep = 1;
    String randomSeed = "a";

    public void testAll() {
        Log.d((String)"***** JPEG-STEGO ******", (String)"testAll() begin");
        boolean t1 = this.testEncodeBits2Byte();
        boolean t2 = this.testEncodeInt2Bytes();
        boolean t3 = this.testEmbedExtractBit();
        boolean t4 = this.testRandom();
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("TESTS: t1 %b t2 %b t3 %b t4 %b", t1, t2, t3, t4));
        Log.d((String)"***** JPEG-STEGO ******", (String)"testAll() end");
    }

    public boolean testEncodeBits2Byte() {
        int[] bits = new int[8];
        boolean res = true;
        for (int i = 0; i < 256; ++i) {
            this.encodeByteToBits(i, bits, 0);
            int j = this.encodeBitsToByte(bits, 0);
            if (i == j || !res) continue;
            res = false;
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("incorrect bs2b: i: %d j: %d", i, j));
            return false;
        }
        return res;
    }

    public boolean testEncodeInt2Bytes() {
        boolean res = true;
        int[] bytes = new int[this.maxLenghtBits / 8];
        for (int i = 0; i < 1 << this.maxLenghtBits; ++i) {
            this.encodeIntToBytes(i, bytes, 0, this.maxLenghtBits / 8);
            int j = this.encodeBytesToInt(bytes, 0, this.maxLenghtBits / 8);
            if (i == j || !res) continue;
            res = false;
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("incorrect i2bs: i: %d j: %d", i, j));
            return false;
        }
        return res;
    }

    public boolean testEmbedExtractBit() {
        boolean res = true;
        for (int type = 1; type <= 2; ++type) {
            for (int c = -10000; c <= 10000; ++c) {
                if (c == 0) continue;
                for (int bit = 0; bit <= 1; ++bit) {
                    int e;
                    int d = this.embedBit(type, c, bit);
                    if (d == 0) {
                        Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("0 generated by embedding: type: %d c: %d bit: %d d: %d", type, c, bit, d));
                    }
                    if (bit == (e = this.extractBit(type, d)) || !res) continue;
                    Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("embedding b: type: %d c: %d bit: %d d: %d e:%d", type, c, bit, d, e));
                    res = false;
                    return false;
                }
            }
        }
        return res;
    }

    public boolean testRandom() {
        int n = 40;
        int m = 1000;
        for (int j = 0; j < m; ++j) {
            int[] a = this.getRandomPermutation(n);
            int[] b = this.getRandomPermutation(n);
            for (int i = 0; i < n; ++i) {
                if (a[i] == b[i]) continue;
                Log.d((String)"***** JPEG-STEGO ******", (String)"different randoms");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean loadKeyFromString(String s) {
        if (s != null) {
            this.randomSeed = s;
            return true;
        }
        return false;
    }

    private boolean isOdd(int x) {
        if (x >= 0) {
            return x % 2 == 1;
        }
        return -x % 2 == 1;
    }

    private boolean isEven(int x) {
        return !this.isOdd(x);
    }

    public int[] selectNonZeroCoeffs(int[] coeff) {
        int[] allNonZeroCoeffs = new int[coeff.length];
        int nonZeroCount = 0;
        for (int i = 0; i < coeff.length; ++i) {
            if (coeff[i] == 0) continue;
            allNonZeroCoeffs[nonZeroCount] = i;
            ++nonZeroCount;
        }
        int[] res = new int[nonZeroCount];
        System.arraycopy(allNonZeroCoeffs, 0, res, 0, nonZeroCount);
        return res;
    }

    @Override
    public String generateStegoKeyString() {
        byte[] a = new byte[60];
        SecureRandom srand = new SecureRandom();
        srand.nextBytes(a);
        return Base64.encodeToString((byte[])a, (int)2);
    }

    public int[] getRandomPermutation(int amount) {
        F5Random random = new F5Random(this.randomSeed);
        Permutation permutation = new Permutation(amount, random);
        int[] perm = new int[amount];
        for (int i = 0; i < amount; ++i) {
            perm[i] = permutation.getShuffled(i);
        }
        return perm;
    }

    public int[] getPermutedNonZeroCoeffs(int[] coeff) {
        int[] nonZeroCoeffs = this.selectNonZeroCoeffs(coeff);
        int[] perm = this.getRandomPermutation(nonZeroCoeffs.length);
        int[] qperm = new int[perm.length];
        for (int i = 0; i < qperm.length; ++i) {
            qperm[i] = nonZeroCoeffs[perm[i]];
        }
        return qperm;
    }

    public int[] getNon64PermutedNonZeroCoeffs(int[] coeff) {
        int[] qperm = this.getPermutedNonZeroCoeffs(coeff);
        int non64count = 0;
        for (int i = 0; i < qperm.length; ++i) {
            if (qperm[i] % 64 == 0) continue;
            qperm[non64count] = qperm[i];
            ++non64count;
        }
        int[] res = new int[non64count];
        System.arraycopy(qperm, 0, res, 0, non64count);
        return res;
    }

    public int[] getSmallCoeffs(int[] coeff, int type) {
        int[] qperm = this.getNon64PermutedNonZeroCoeffs(coeff);
        int[] good_coeffs = new int[qperm.length];
        int goodCount = 0;
        int maxCoeff = -100000;
        int minCoeff = 100000;
        for (int i = 0; i < qperm.length; ++i) {
            if (coeff[qperm[i]] < -this.maxCoeffRange || coeff[qperm[i]] > this.maxCoeffRange) {
                // empty if block
            }
            good_coeffs[goodCount] = qperm[i];
            ++goodCount;
            if (coeff[qperm[i]] > maxCoeff) {
                maxCoeff = coeff[qperm[i]];
            }
            if (coeff[qperm[i]] >= minCoeff) continue;
            minCoeff = coeff[qperm[i]];
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("maxCoeff %d minCoeff %d", maxCoeff, minCoeff));
        int[] res = new int[goodCount];
        System.arraycopy(good_coeffs, 0, res, 0, goodCount);
        return res;
    }

    public int[] getNon64NonZeroPermutedCoeffs(int[] coeff) {
        int[] perm = this.getRandomPermutation(coeff.length);
        int[] nonZeroNon64perm = new int[coeff.length];
        int goodCoeffCount = 0;
        for (int i = 0; i < coeff.length; ++i) {
            int q = perm[i];
            if (coeff[q] == 0 || q % 64 == 0) continue;
            nonZeroNon64perm[goodCoeffCount] = q;
            ++goodCoeffCount;
        }
        int[] res = new int[goodCoeffCount];
        System.arraycopy(nonZeroNon64perm, 0, res, 0, goodCoeffCount);
        return res;
    }

    public int[] getGoodCoeffs(int[] coeff) {
        int[] a = this.getRandomPermutation(coeff.length);
        int non64 = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] % 64 == 0) continue;
            a[non64] = a[i];
            ++non64;
        }
        int[] res = new int[non64];
        System.arraycopy(a, 0, res, 0, non64);
        return res;
    }

    public void encodeByteToBits(int x, int[] dst, int pos) {
        int q = x;
        for (int i = 0; i < 8; ++i) {
            int res;
            dst[pos + i] = res = q % 2;
            q /= 2;
        }
    }

    public int encodeBitsToByte(int[] src, int pos) {
        int q = 0;
        for (int i = 7; i >= 0; --i) {
            q = 2 * q + src[pos + i];
        }
        return q;
    }

    public void encodeIntToBytes(int x, int[] dst, int pos, int length) {
        for (int i = 0; i < length; ++i) {
            dst[pos + i] = x >> 8 * i & 0xFF;
        }
    }

    public int encodeBytesToInt(int[] src, int pos, int length) {
        int x = 0;
        for (int i = 0; i < length; ++i) {
            x += src[pos + i] << 8 * i;
        }
        return x;
    }

    public int embedBitUnsafe(int type, int c, int bit) {
        if (c == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"zero coeff!?!");
            return 0;
        }
        if (type == 1) {
            if (c > 0 && this.isOdd(c)) {
                if (bit == 0 && c - 1 == 0) {
                    return c - 2;
                }
                if (bit == 0 && c - 1 != 0) {
                    return c - 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c > 0 && this.isEven(c)) {
                if (bit == 1) {
                    return c - 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c < 0 && this.isOdd(c)) {
                if (bit == 1) {
                    return c - 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c < 0 && this.isEven(c)) {
                if (bit == 0) {
                    return c - 1;
                }
                if (bit == 1) {
                    return c;
                }
            }
        } else if (type == 2) {
            if (c > 0 && this.isOdd(c)) {
                if (bit == 1) {
                    return c + 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c > 0 && this.isEven(c)) {
                if (bit == 0) {
                    return c + 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c < 0 && this.isOdd(c)) {
                if (bit == 0 && c + 1 == 0) {
                    return c + 2;
                }
                if (bit == 0 && c + 1 != 0) {
                    return c + 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c < 0 && this.isEven(c)) {
                if (bit == 1) {
                    return c + 1;
                }
                if (bit == 0) {
                    return c;
                }
            }
        } else {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"type != {1, 2}");
            return 0;
        }
        Log.wtf((String)"***** JPEG-STEGO ******", (String)"embed bit: this should never occur");
        return 0;
    }

    public int embedBit(int type, int c, int bit) {
        int res = this.embedBitUnsafe(type, c, bit);
        if (res == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("we embedded zero?!! type: %d c: %d bit: %d", type, c, bit));
        }
        return res;
    }

    public int extractBit(int type, int c) {
        if (c == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"zero coeff!?!");
            return 0;
        }
        if (type == 1) {
            if (c > 0 && this.isEven(c)) {
                return 0;
            }
            if (c < 0 && this.isOdd(c)) {
                return 0;
            }
            if (c > 0 && this.isOdd(c)) {
                return 1;
            }
            if (c < 0 && this.isEven(c)) {
                return 1;
            }
        } else if (type == 2) {
            if (c > 0 && this.isOdd(c)) {
                return 0;
            }
            if (c < 0 && this.isEven(c)) {
                return 0;
            }
            if (c > 0 && this.isEven(c)) {
                return 1;
            }
            if (c < 0 && this.isOdd(c)) {
                return 1;
            }
        } else {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"type != {1, 2}");
            return 0;
        }
        Log.wtf((String)"***** JPEG-STEGO ******", (String)"extract bit: this should never occur");
        return 0;
    }

    public int extractBitRep(int type, int[] c, int pos) {
        if (c.length < 1 + pos) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"incorrect tuple length!!");
        }
        int sum = 0;
        for (int z = 0; z < 1; ++z) {
            sum += this.extractBit(type, c[pos + z]);
        }
        if (sum > 0) {
            return 1;
        }
        return 0;
    }

    public void embedPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, int[] M) {
        int j;
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("embedPart: type: %d qbegin: %d qend: %d Mlength: %d", type, qbegin, qend, M.length));
        if (8 * M.length > qend - qbegin) {
            Log.e((String)"***** JPEG-STEGO ******", (String)"message is too long");
        }
        int[] octet = new int[8];
        int zeroCoeffs = 0;
        for (j = 0; j < Math.min((qend - qbegin) / 8, M.length); ++j) {
            this.encodeByteToBits(M[j], octet, 0);
            for (int k = 0; k < 8; ++k) {
                for (int z = 0; z < 1; ++z) {
                    int qi = qbegin + (j * 8 + k) * 1 + z + zeroCoeffs;
                    while (coeff[qperm[qi]] == 0) {
                        ++qi;
                        ++zeroCoeffs;
                    }
                    int i = qperm[qi];
                    coeff[i] = this.embedBit(type, coeff[i], octet[k]);
                }
            }
        }
        zeroCoeffs = 0;
        if (type == 1) {
            for (j = 0; j < (int)(this.beta * (double)M.length * 8.0 * 1.0); ++j) {
                int qi = qbegin + j + zeroCoeffs;
                while (coeff[qperm[qi]] == 0) {
                    ++qi;
                    ++zeroCoeffs;
                }
                int i = qperm[qi];
                if (coeff[i] != -2) continue;
                coeff[i] = 1;
            }
        }
    }

    public void extractPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, ByteArrayOutputStream fos) {
        this.extractPart(type, coeff, qperm, qbegin, qend, fos, null);
    }

    public void extractPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, ByteArrayOutputStream fos, int[] S) {
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("extractPart: type: %d qbegin: %d qend: %d", type, qbegin, qend));
        int[] lengthCoeffsRep = new int[16];
        if (qend - qbegin < 16) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"Coeffs are too small for length encoding?!!");
            return;
        }
        int zeroCoeffs = 0;
        for (int i = 0; i < lengthCoeffsRep.length; ++i) {
            int qi = qbegin + i + zeroCoeffs;
            while (coeff[qperm[qi]] == 0) {
                ++qi;
                ++zeroCoeffs;
            }
            lengthCoeffsRep[i] = coeff[qperm[qi]];
        }
        int[] lengthBits = new int[16];
        for (int i = 0; i < 16; ++i) {
            lengthBits[i] = this.extractBitRep(type, lengthCoeffsRep, 1 * i);
        }
        int[] lengthBytes = new int[2];
        for (int i = 0; i < 2; ++i) {
            lengthBytes[i] = this.encodeBitsToByte(lengthBits, 8 * i);
        }
        int L = this.encodeBytesToInt(lengthBytes, 0, 2);
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("L: %d", L));
        qbegin += 16;
        int[] octet = new int[8];
        int[] tuple = new int[1];
        for (int j = 0; j < Math.min(L, (qend - qbegin) / 8); ++j) {
            for (int k = 0; k < 8; ++k) {
                for (int z = 0; z < 1; ++z) {
                    int qi = qbegin + (j * 8 + k) * 1 + z + zeroCoeffs;
                    while (coeff[qperm[qi]] == 0) {
                        ++qi;
                        ++zeroCoeffs;
                    }
                    int i = qperm[qi];
                    tuple[z] = coeff[i];
                }
                octet[k] = this.extractBitRep(type, tuple, 0);
            }
            int b = this.encodeBitsToByte(octet, 0);
            if (S != null) {
                S[j] = b;
                continue;
            }
            fos.write((byte)b);
        }
    }

    public int getQSep(int length) {
        return (int)(this.alpha * (double)length);
    }

    @Override
    public void embed(int[] coeffOrig, InputStream embeddedData) {
        String c = "";
        for (int i = 0; i < 1000; ++i) {
            c = c + String.valueOf(coeffOrig[i]) + " ";
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("coeffOrig: " + c));
        try {
            int k;
            int i;
            int Clength = Math.min(this.maxCoeffs, coeffOrig.length);
            int[] coeff = new int[Clength];
            System.arraycopy(coeffOrig, 0, coeff, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Embedding started");
            int[] qperm = this.getGoodCoeffs(coeff);
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("qperm length: %d", qperm.length));
            String c2 = "";
            for (i = 0; i < 1000; ++i) {
                c2 = c2 + String.valueOf(coeff[qperm[i]]) + " ";
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)("coeff: " + c2));
            c2 = "";
            for (i = 0; i < 1000; ++i) {
                c2 = c2 + String.valueOf(qperm[i]) + " ";
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)("qperm: " + c2));
            int Qsep = this.getQSep(qperm.length);
            int Slength = 0;
            int[] S = new int[50000];
            while ((k = embeddedData.available()) != 0) {
                S[Slength] = embeddedData.read();
                ++Slength;
            }
            int Ssep = this.getQSep(Slength);
            int[] M1 = new int[2 + Ssep];
            System.arraycopy(S, 0, M1, 2, Ssep);
            this.encodeIntToBytes(M1.length - 2, M1, 0, 2);
            int[] M2 = new int[2 + Slength - Ssep];
            System.arraycopy(S, Ssep, M2, 2, Slength - Ssep);
            this.encodeIntToBytes(M2.length - 2, M2, 0, 2);
            this.embedPart(1, coeff, qperm, 0, Qsep, M1);
            this.embedPart(2, coeff, qperm, Qsep, qperm.length, M2);
            System.arraycopy(coeff, 0, coeffOrig, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Embedding ended");
            int[] ES1 = new int[Slength + 4];
            this.extractPart(1, coeff, qperm, 0, Qsep, null, ES1);
            boolean s1correct = true;
            for (int i2 = 0; i2 < Ssep; ++i2) {
                if (ES1[i2] == M1[2 + i2]) continue;
                s1correct = false;
                break;
            }
            if (!s1correct) {
                Log.e((String)"***** JPEG-STEGO ******", (String)"first part embedded incorrectly :(((");
            }
            int[] ES2 = new int[Slength + 4];
            this.extractPart(2, coeff, qperm, Qsep, qperm.length, null, ES2);
            boolean s2correct = true;
            for (int i3 = 0; i3 < Slength - Ssep; ++i3) {
                if (ES2[i3] == M2[2 + i3]) continue;
                s2correct = false;
                break;
            }
            if (!s2correct) {
                Log.e((String)"***** JPEG-STEGO ******", (String)"second part embedded incorrectly :(((");
            }
        }
        catch (Exception e) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("Something went brutally wrong during embedding :/ Error: %s", e.toString()));
        }
    }

    @Override
    public void extract(int[] coeffOrig, ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        int i;
        boolean isNonZero = false;
        for (i = 0; i < coeffOrig.length; ++i) {
            if (coeffOrig[i] == 0) continue;
            isNonZero = true;
            break;
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("isNonZero: %b", isNonZero));
        String c = "";
        for (i = 0; i < 1000; ++i) {
            c = c + String.valueOf(coeffOrig[i]) + " ";
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("coeffOrig: " + c));
        try {
            int i2;
            int Clength = Math.min(this.maxCoeffs, coeffOrig.length);
            int[] coeff = new int[Clength];
            System.arraycopy(coeffOrig, 0, coeff, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Extraction started");
            int[] qperm = this.getGoodCoeffs(coeff);
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("qperm length: %d", qperm.length));
            String c2 = "";
            for (i2 = 0; i2 < 1000; ++i2) {
                c2 = c2 + String.valueOf(coeff[qperm[i2]]) + " ";
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)("coeffOrig: " + c2));
            c2 = "";
            for (i2 = 0; i2 < 1000; ++i2) {
                c2 = c2 + String.valueOf(qperm[i2]) + " ";
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)("qperm: " + c2));
            int Qsep = this.getQSep(qperm.length);
            this.extractPart(1, coeff, qperm, 0, Qsep, fos);
            this.extractPart(2, coeff, qperm, Qsep, qperm.length, fos);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Extraction ended");
            Log.d((String)"***** JPEG-STEGO ******", (String)String.valueOf(fos));
            listener.onExtractionResult(fos);
        }
        catch (Exception e) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("Something went brutally wrong during extracting :/ Error: %s", e.toString()));
        }
    }
}

