/*
 * Decompiled with CFR 0.152.
 */
package net.f5.ortega;

import java.io.DataInputStream;
import java.io.IOException;

public class HuffTable {
    private final int[] BITS = new int[17];
    private final int[] HUFFVAL = new int[256];
    private final int[] HUFFCODE = new int[257];
    private final int[] HUFFSIZE = new int[257];
    private final int[] EHUFCO = new int[257];
    private final int[] EHUFSI = new int[257];
    private final int[] MINCODE = new int[17];
    private final int[] MAXCODE = new int[18];
    private final int[] VALPTR = new int[17];
    private final int Ln;
    private int SI;
    private int I;
    private int J;
    private int K;
    private int LASTK;
    private int CODE;
    DataInputStream dis;

    public HuffTable(DataInputStream d, int l) {
        this.dis = d;
        this.Ln = 19 + this.getTableData();
        this.Generate_size_table();
        this.Generate_code_table();
        this.Order_codes();
        this.Decoder_tables();
    }

    private void Decoder_tables() {
        this.I = 0;
        this.J = 0;
        while (++this.I <= 16) {
            if (this.BITS[this.I] == 0) {
                this.MAXCODE[this.I] = -1;
                continue;
            }
            this.VALPTR[this.I] = this.J;
            this.MINCODE[this.I] = this.HUFFCODE[this.J];
            this.J = this.J + this.BITS[this.I] - 1;
            this.MAXCODE[this.I] = this.HUFFCODE[this.J++];
        }
        return;
    }

    private void Generate_code_table() {
        this.K = 0;
        this.CODE = 0;
        this.SI = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[this.K++] = this.CODE++;
            if (this.HUFFSIZE[this.K] == this.SI) continue;
            if (this.HUFFSIZE[this.K] == 0) break;
            do {
                this.CODE <<= 1;
                ++this.SI;
            } while (this.HUFFSIZE[this.K] != this.SI);
        }
    }

    private void Generate_size_table() {
        this.K = 0;
        this.I = 1;
        this.J = 1;
        while (true) {
            if (this.J > this.BITS[this.I]) {
                this.J = 1;
                ++this.I;
                if (this.I <= 16) continue;
                break;
            }
            this.HUFFSIZE[this.K++] = this.I;
            ++this.J;
        }
        this.HUFFSIZE[this.K] = 0;
        this.LASTK = this.K;
    }

    private int getByte() {
        try {
            return this.dis.readUnsignedByte();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public int[] getHUFFVAL() {
        return this.HUFFVAL;
    }

    public int getLen() {
        return this.Ln;
    }

    public int[] getMAXCODE() {
        return this.MAXCODE;
    }

    public int[] getMINCODE() {
        return this.MINCODE;
    }

    private int getTableData() {
        int x;
        int count = 0;
        for (x = 1; x < 17; ++x) {
            this.BITS[x] = this.getByte();
            count += this.BITS[x];
        }
        for (x = 0; x < count; ++x) {
            this.HUFFVAL[x] = this.getByte();
        }
        return count;
    }

    public int[] getVALPTR() {
        return this.VALPTR;
    }

    private void Order_codes() {
        this.K = 0;
        do {
            this.I = this.HUFFVAL[this.K];
            this.EHUFCO[this.I] = this.HUFFCODE[this.K];
            this.EHUFSI[this.I] = this.HUFFSIZE[this.K++];
        } while (this.K < this.LASTK);
    }
}

