/*
 * Decompiled with CFR 0.152.
 */
package net.f5.ortega;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import net.f5.ortega.HuffTable;

public class HuffmanDecode {
    private static final int APP0 = 224;
    private static final int APP1 = 225;
    private static final int APP2 = 226;
    private static final int APP3 = 227;
    private static final int APP4 = 228;
    private static final int APP5 = 229;
    private static final int APP6 = 230;
    private static final int APP7 = 231;
    private static final int APP8 = 232;
    private static final int APP9 = 233;
    private static final int APP10 = 234;
    private static final int APP11 = 235;
    private static final int APP12 = 236;
    private static final int APP13 = 237;
    private static final int APP14 = 238;
    private static final int APP15 = 239;
    private static final int DRI = 221;
    private static final int DNL = 220;
    private static final int EOI = 217;
    private int Lf;
    private int P;
    private int X;
    private int Y;
    private int Nf;
    private int[] C;
    private int[] H;
    private int[] V;
    private int[] T;
    private int Ls;
    private int Ns;
    private int Ss;
    private int Se;
    private int Ah;
    private int Al;
    private int[] Cs;
    private int[] Td;
    private int[] Ta;
    private int Lh;
    private int Tc;
    private int Th;
    private int Lq;
    private int Pq;
    private int Tq;
    private int Ld;
    private int Nl;
    private int Lr;
    private int Ri;
    private int B;
    private int CNT;
    private int DIFF;
    private int PRED;
    private final int size;
    private int K;
    private int SSSS;
    private int RS;
    private int R;
    private int J;
    private int CODE;
    private int lp;
    private int cnt;
    private int a;
    private int b;
    private int hftbl;
    private int[][][] Cr;
    private int[][][] Cb;
    private final int[][] HUFFVAL = new int[4][];
    private final int[][] VALPTR = new int[4][];
    private final int[][] MINCODE = new int[4][];
    private final int[][] MAXCODE = new int[4][];
    private final int[] ZZ = new int[64];
    private final int[][] QNT = new int[4][64];
    private int RI;
    private static byte[][] deZZ = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {2, 0}, {1, 1}, {0, 2}, {0, 3}, {1, 2}, {2, 1}, {3, 0}, {4, 0}, {3, 1}, {2, 2}, {1, 3}, {0, 4}, {0, 5}, {1, 4}, {2, 3}, {3, 2}, {4, 1}, {5, 0}, {6, 0}, {5, 1}, {4, 2}, {3, 3}, {2, 4}, {1, 5}, {0, 6}, {0, 7}, {1, 6}, {2, 5}, {3, 4}, {4, 3}, {5, 2}, {6, 1}, {7, 0}, {7, 1}, {6, 2}, {5, 3}, {4, 4}, {3, 5}, {2, 6}, {1, 7}, {2, 7}, {3, 6}, {4, 5}, {5, 4}, {6, 3}, {7, 2}, {7, 3}, {6, 4}, {5, 5}, {4, 6}, {3, 7}, {4, 7}, {5, 6}, {6, 5}, {7, 4}, {7, 5}, {6, 6}, {5, 7}, {6, 7}, {7, 6}, {7, 7}};
    private static byte[] deZigZag = new byte[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    HuffTable htDC0;
    HuffTable htDC1;
    HuffTable htAC0;
    HuffTable htAC1;
    DataInputStream dis;
    Date dt;

    public HuffmanDecode(byte[] data) {
        this.size = (short)data.length;
        this.dis = new DataInputStream(new ByteArrayInputStream(data));
        boolean cont = true;
        while (cont) {
            if (255 != this.getByte()) continue;
            switch (this.getByte()) {
                case 192: {
                    this.sof0();
                    break;
                }
                case 196: {
                    this.dht();
                    break;
                }
                case 219: {
                    this.dqt();
                    break;
                }
                case 217: {
                    cont = false;
                    break;
                }
                case 218: {
                    cont = false;
                    break;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    this.skipVariable();
                    break;
                }
                case 221: {
                    this.dri();
                }
            }
        }
    }

    private int available() {
        try {
            return this.dis.available();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void closeStream() {
        try {
            this.dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int[] decode() {
        int pos;
        int[] buff;
        block11: {
            int[] PRED = new int[this.Nf];
            for (int nComponent = 0; nComponent < this.Nf; ++nComponent) {
                PRED[nComponent] = 0;
            }
            this.CNT = 0;
            this.Ls = this.getInt();
            this.Ns = this.getByte();
            int[] Cs = new int[this.Ns];
            int[] Td = new int[this.Ns];
            int[] Ta = new int[this.Ns];
            this.lp = 0;
            while (this.lp < this.Ns) {
                Cs[this.lp] = this.getByte();
                Td[this.lp] = this.getByte();
                Ta[this.lp] = Td[this.lp] & 0xF;
                int n = this.lp++;
                Td[n] = Td[n] >> 4;
            }
            this.Ss = this.getByte();
            this.Se = this.getByte();
            this.Ah = this.getByte();
            this.Al = this.Ah & 0xF;
            this.Ah >>= 4;
            buff = new int[128 * this.getBlockCount()];
            pos = 0;
            int MCUCount = 0;
            boolean bDoIt = true;
            do {
                int nComponent;
                for (nComponent = 0; nComponent < this.Nf; ++nComponent) {
                    this.cnt = 0;
                    while (this.cnt < this.H[nComponent] * this.V[nComponent]) {
                        this.hftbl = Td[nComponent] * 2;
                        int tmp = this.DECODE();
                        this.DIFF = this.RECEIVE(tmp);
                        this.ZZ[0] = PRED[0] + this.EXTEND(this.DIFF, tmp);
                        PRED[nComponent] = this.ZZ[0];
                        this.hftbl = Ta[nComponent] * 2 + 1;
                        this.Decode_AC_coefficients();
                        this.lp = 0;
                        while (this.lp < 64) {
                            buff[pos++] = this.ZZ[this.lp];
                            ++this.lp;
                        }
                        ++this.cnt;
                    }
                }
                if (++MCUCount != this.RI) continue;
                MCUCount = 0;
                this.CNT = 0;
                for (nComponent = 0; nComponent < this.Nf; ++nComponent) {
                    PRED[nComponent] = 0;
                }
                this.getByte();
                int tmpB = this.getByte();
                if (tmpB == 217) break block11;
            } while (this.available() > 2);
            if (this.available() == 2) {
                this.getByte();
                if (this.getByte() != 217) {
                    System.out.println("file does not end with EOI");
                }
            } else {
                if (this.available() > 0) {
                    System.out.println(Integer.toHexString(this.getByte()));
                }
                System.out.println("file does not end with EOI");
            }
        }
        int[] tmpBuff = new int[pos];
        System.arraycopy(buff, 0, tmpBuff, 0, pos);
        return tmpBuff;
    }

    private int DECODE() {
        int CD = this.NextBit();
        int I = 1;
        while (CD > this.MAXCODE[this.hftbl][I]) {
            CD = (CD << 1) + this.NextBit();
            ++I;
        }
        this.J = this.VALPTR[this.hftbl][I];
        this.J = this.J + CD - this.MINCODE[this.hftbl][I];
        int VALUE = this.HUFFVAL[this.hftbl][this.J];
        return VALUE;
    }

    private void Decode_AC_coefficients() {
        this.K = 1;
        this.lp = 1;
        while (this.lp < 64) {
            this.ZZ[this.lp] = 0;
            ++this.lp;
        }
        while (true) {
            this.RS = this.DECODE();
            this.SSSS = this.RS % 16;
            this.R = this.RS >> 4;
            if (this.SSSS == 0) {
                if (this.R == 15) {
                    this.K += 16;
                    continue;
                }
                return;
            }
            this.K += this.R;
            this.Decode_ZZ(this.K);
            if (this.K == 63) {
                return;
            }
            ++this.K;
        }
    }

    private void Decode_ZZ(int k) {
        this.ZZ[k] = this.RECEIVE(this.SSSS);
        this.ZZ[k] = this.EXTEND(this.ZZ[k], this.SSSS);
    }

    private void dht() {
        this.Lh = this.getInt();
        while (this.Lh > 0) {
            this.Tc = this.getByte();
            this.Th = this.Tc & 0xF;
            this.Tc >>= 4;
            if (this.Th == 0) {
                if (this.Tc == 0) {
                    this.htDC0 = new HuffTable(this.dis, this.Lh);
                    this.Lh -= this.htDC0.getLen();
                    this.HUFFVAL[0] = this.htDC0.getHUFFVAL();
                    this.VALPTR[0] = this.htDC0.getVALPTR();
                    this.MAXCODE[0] = this.htDC0.getMAXCODE();
                    this.MINCODE[0] = this.htDC0.getMINCODE();
                    this.htDC0 = null;
                    System.gc();
                    continue;
                }
                this.htAC0 = new HuffTable(this.dis, this.Lh);
                this.Lh -= this.htAC0.getLen();
                this.HUFFVAL[1] = this.htAC0.getHUFFVAL();
                this.VALPTR[1] = this.htAC0.getVALPTR();
                this.MAXCODE[1] = this.htAC0.getMAXCODE();
                this.MINCODE[1] = this.htAC0.getMINCODE();
                this.htAC0 = null;
                System.gc();
                continue;
            }
            if (this.Tc == 0) {
                this.htDC1 = new HuffTable(this.dis, this.Lh);
                this.Lh -= this.htDC1.getLen();
                this.HUFFVAL[2] = this.htDC1.getHUFFVAL();
                this.VALPTR[2] = this.htDC1.getVALPTR();
                this.MAXCODE[2] = this.htDC1.getMAXCODE();
                this.MINCODE[2] = this.htDC1.getMINCODE();
                this.htDC1 = null;
                System.gc();
                continue;
            }
            this.htAC1 = new HuffTable(this.dis, this.Lh);
            this.Lh -= this.htAC1.getLen();
            this.HUFFVAL[3] = this.htAC1.getHUFFVAL();
            this.VALPTR[3] = this.htAC1.getVALPTR();
            this.MAXCODE[3] = this.htAC1.getMAXCODE();
            this.MINCODE[3] = this.htAC1.getMINCODE();
            this.htAC1 = null;
            System.gc();
        }
    }

    private void dqt() {
        this.Lq = this.getInt();
        this.Pq = this.getByte();
        this.Tq = this.Pq & 0xF;
        this.Pq >>= 4;
        switch (this.Tq) {
            case 0: {
                this.lp = 0;
                while (this.lp < 64) {
                    this.QNT[0][this.lp] = this.getByte();
                    ++this.lp;
                }
                break;
            }
            case 1: {
                this.lp = 0;
                while (this.lp < 64) {
                    this.QNT[1][this.lp] = this.getByte();
                    ++this.lp;
                }
                break;
            }
            case 2: {
                this.lp = 0;
                while (this.lp < 64) {
                    this.QNT[2][this.lp] = this.getByte();
                    ++this.lp;
                }
                break;
            }
            case 3: {
                this.lp = 0;
                while (this.lp < 64) {
                    this.QNT[3][this.lp] = this.getByte();
                    ++this.lp;
                }
                break;
            }
        }
    }

    private void dri() {
        this.getInt();
        this.RI = this.getInt();
    }

    private int EXTEND(int V, int T) {
        int Vt = 1 << T - 1;
        if (V < Vt) {
            Vt = (-1 << T) + 1;
            V += Vt;
        }
        return V;
    }

    public int getBlockCount() {
        switch (this.Nf) {
            case 1: {
                return (this.X + 7) / 8 * ((this.Y + 7) / 8);
            }
            case 3: {
                return 6 * ((this.X + 15) / 16) * ((this.Y + 15) / 16);
            }
        }
        System.out.println("Nf weder 1 noch 3");
        return 0;
    }

    public int getByte() {
        int b = 0;
        try {
            b = this.dis.readUnsignedByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public int getComp() {
        return this.Nf;
    }

    public int getInt() {
        int b = 0;
        try {
            b = this.dis.readUnsignedByte();
            b <<= 8;
            int tmp = this.dis.readUnsignedByte();
            b ^= tmp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public int getPrec() {
        return this.P;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public void HuffDecode(int[][][] buffer) {
        int sz = this.X * this.Y;
        boolean scan = false;
        int[][] Block = new int[8][8];
        this.Ls = this.getInt();
        this.Ns = this.getByte();
        int Cs = this.getByte();
        int Td = this.getByte();
        int Ta = Td & 0xF;
        Td >>= 4;
        this.Ss = this.getByte();
        this.Se = this.getByte();
        this.Ah = this.getByte();
        this.Al = this.Ah & 0xF;
        this.Ah >>= 4;
        int blocks = this.getBlockCount() / 6;
        this.cnt = 0;
        while (this.cnt < blocks) {
            this.hftbl = Td == 0 ? 0 : 2;
            int tmp = this.DECODE();
            this.DIFF = this.RECEIVE(tmp);
            this.ZZ[0] = this.PRED + this.EXTEND(this.DIFF, tmp);
            this.PRED = this.ZZ[0];
            this.hftbl = Ta == 0 ? 1 : 3;
            this.Decode_AC_coefficients();
            this.lp = 0;
            while (this.lp < 64) {
                Block[HuffmanDecode.deZZ[this.lp][0]][HuffmanDecode.deZZ[this.lp][1]] = this.ZZ[this.lp] * this.QNT[0][this.lp];
                ++this.lp;
            }
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    buffer[this.cnt][x][y] = Block[x][y];
                }
            }
            ++this.cnt;
        }
        this.closeStream();
    }

    private int NextBit() {
        if (this.CNT == 0) {
            this.CNT = 8;
            this.B = this.getByte();
            if (255 == this.B) {
                int n = this.getByte();
            }
        }
        int BIT = this.B & 0x80;
        --this.CNT;
        this.B <<= 1;
        return BIT >>= 7;
    }

    public void rawDecode(int[][][] buffer) {
        int[][] Block = new int[8][8];
        this.Ls = this.getInt();
        this.Ns = this.getByte();
        int Cs = this.getByte();
        int Td = this.getByte();
        int Ta = Td & 0xF;
        Td >>= 4;
        this.Ss = this.getByte();
        this.Se = this.getByte();
        this.Ah = this.getByte();
        this.Al = this.Ah & 0xF;
        this.Ah >>= 4;
        int blocks = this.getBlockCount() / 6;
        this.cnt = 0;
        while (this.cnt < blocks) {
            this.hftbl = Td == 0 ? 0 : 2;
            int tmp = this.DECODE();
            this.DIFF = this.RECEIVE(tmp);
            this.ZZ[0] = this.PRED + this.EXTEND(this.DIFF, tmp);
            this.PRED = this.ZZ[0];
            this.hftbl = Ta == 0 ? 1 : 3;
            this.Decode_AC_coefficients();
            this.lp = 0;
            while (this.lp < 64) {
                Block[HuffmanDecode.deZZ[this.lp][0]][HuffmanDecode.deZZ[this.lp][1]] = this.ZZ[this.lp];
                ++this.lp;
            }
            System.out.print(this.cnt + " ");
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    buffer[this.cnt][x][y] = Block[x][y];
                }
            }
            ++this.cnt;
        }
        this.closeStream();
    }

    private int RECEIVE(int SSS) {
        int V = 0;
        int I = 0;
        while (I != SSS) {
            ++I;
            V = (V << 1) + this.NextBit();
        }
        return V;
    }

    public void RGBdecode(int[][][] Lum) {
        int sz = this.X * this.Y;
        boolean scan = false;
        int[][] Block = new int[8][8];
        int[] PRED = new int[]{0, 0, 0};
        this.Ls = this.getInt();
        this.Ns = this.getByte();
        int[] Cs = new int[this.Ns];
        int[] Td = new int[this.Ns];
        int[] Ta = new int[this.Ns];
        this.lp = 0;
        while (this.lp < this.Ns) {
            Cs[this.lp] = this.getByte();
            Td[this.lp] = this.getByte();
            Ta[this.lp] = Td[this.lp] & 0xF;
            int n = this.lp++;
            Td[n] = Td[n] >> 4;
        }
        this.Ss = this.getByte();
        this.Se = this.getByte();
        this.Ah = this.getByte();
        this.Al = this.Ah & 0xF;
        this.Ah >>= 4;
        int blocks = this.getBlockCount() / 6;
        int col = 2;
        for (int a = 0; a < 32; ++a) {
            for (int b = 0; b < 32; ++b) {
                int y;
                int x;
                int tmp;
                this.cnt = 0;
                while (this.cnt < 4) {
                    this.hftbl = 0;
                    tmp = this.DECODE();
                    this.DIFF = this.RECEIVE(tmp);
                    this.ZZ[0] = PRED[0] + this.EXTEND(this.DIFF, tmp);
                    PRED[0] = this.ZZ[0];
                    this.hftbl = 1;
                    this.Decode_AC_coefficients();
                    this.lp = 0;
                    while (this.lp < 64) {
                        Block[HuffmanDecode.deZZ[this.lp][0]][HuffmanDecode.deZZ[this.lp][1]] = this.ZZ[this.lp] * this.QNT[0][this.lp];
                        ++this.lp;
                    }
                    int line = this.cnt < 2 ? 0 : 62;
                    for (x = 0; x < 8; ++x) {
                        for (y = 0; y < 8; ++y) {
                            Lum[b * 2 + this.cnt + line + a * 128][x][y] = Block[x][y];
                        }
                    }
                    ++this.cnt;
                }
                this.cnt = 0;
                while (this.cnt < 2) {
                    this.hftbl = 2;
                    tmp = this.DECODE();
                    this.DIFF = this.RECEIVE(tmp);
                    this.ZZ[0] = PRED[this.cnt + 1] + this.EXTEND(this.DIFF, tmp);
                    PRED[this.cnt + 1] = this.ZZ[0];
                    this.hftbl = 3;
                    this.Decode_AC_coefficients();
                    this.lp = 0;
                    while (this.lp < 64) {
                        Block[HuffmanDecode.deZZ[this.lp][0]][HuffmanDecode.deZZ[this.lp][1]] = this.ZZ[this.lp] * this.QNT[1][this.lp];
                        ++this.lp;
                    }
                    if (this.cnt == 0) {
                        for (x = 0; x < 8; ++x) {
                            for (y = 0; y < 8; ++y) {
                                this.Cb[a * 32 + b][x][y] = Block[x][y];
                            }
                        }
                    } else {
                        for (x = 0; x < 8; ++x) {
                            for (y = 0; y < 8; ++y) {
                                this.Cr[a * 32 + b][x][y] = Block[x][y];
                            }
                        }
                    }
                    ++this.cnt;
                }
            }
        }
        this.closeStream();
    }

    public void setCb(int[][][] chrome) {
        this.Cb = chrome;
    }

    public void setCr(int[][][] chrome) {
        this.Cr = chrome;
    }

    private void skipVariable() {
        try {
            this.dis.skipBytes(this.getInt() - 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sof0() {
        this.Lf = this.getInt();
        this.P = this.getByte();
        this.Y = this.getInt();
        this.X = this.getInt();
        this.Nf = this.getByte();
        this.C = new int[this.Nf];
        this.H = new int[this.Nf];
        this.V = new int[this.Nf];
        this.T = new int[this.Nf];
        this.lp = 0;
        while (this.lp < this.Nf) {
            this.C[this.lp] = this.getByte();
            this.H[this.lp] = this.getByte();
            this.V[this.lp] = this.H[this.lp] & 0xF;
            int n = this.lp;
            this.H[n] = this.H[n] >> 4;
            this.T[this.lp] = this.getByte();
            ++this.lp;
        }
    }
}

