/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.accounts.Account;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.zzb;
import com.google.android.gms.appdatasearch.zzh;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class DocumentContents
implements SafeParcelable {
    public static final zzb CREATOR = new zzb();
    final int mVersionCode;
    final DocumentSection[] zzPX;
    public final String zzPY;
    public final boolean zzPZ;
    public final Account account;

    DocumentContents(int versionCode, DocumentSection[] sectionContents, String schemaOrgType, boolean globalSearchEnabled, Account account) {
        this.mVersionCode = versionCode;
        this.zzPX = sectionContents;
        this.zzPY = schemaOrgType;
        this.zzPZ = globalSearchEnabled;
        this.account = account;
    }

    DocumentContents(String schemaOrgType, boolean globalSearchEnabled, Account account, DocumentSection ... sections) {
        this(1, sections, schemaOrgType, globalSearchEnabled, account);
        BitSet bitSet = new BitSet(zzh.zzls());
        for (int i = 0; i < sections.length; ++i) {
            int n = sections[i].zzQl;
            if (n == -1) continue;
            if (bitSet.get(n)) {
                throw new IllegalArgumentException("Duplicate global search section type " + zzh.zzak(n));
            }
            bitSet.set(n);
        }
    }

    public String zzln() {
        DocumentSection documentSection = this.zzbw("web_url");
        if (documentSection != null) {
            return documentSection.zzQj;
        }
        return null;
    }

    public DocumentSection zzbw(String string) {
        zzx.zzcr((String)string);
        if (this.zzPX == null) {
            return null;
        }
        for (DocumentSection documentSection : this.zzPX) {
            if (!string.equals(documentSection.zzlp().name)) continue;
            return documentSection;
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public static class zza {
        private List<DocumentSection> zzQa;
        private String zzQb;
        private boolean zzQc;
        private Account zzQd;

        public zza zza(DocumentSection documentSection) {
            if (this.zzQa == null) {
                this.zzQa = new ArrayList<DocumentSection>();
            }
            this.zzQa.add(documentSection);
            return this;
        }

        public zza zzbx(String string) {
            this.zzQb = string;
            return this;
        }

        public zza zzK(boolean bl) {
            this.zzQc = bl;
            return this;
        }

        public zza zzb(Account account) {
            this.zzQd = account;
            return this;
        }

        public DocumentContents zzlo() {
            return new DocumentContents(this.zzQb, this.zzQc, this.zzQd, this.zzQa != null ? this.zzQa.toArray(new DocumentSection[this.zzQa.size()]) : null);
        }
    }
}

