/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.f5android;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;
import james.DCTSteganography;
import james.JpegEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class Embed {
    Activity a;
    Bitmap image = null;
    FileOutputStream dataOut = null;
    File file;
    File outFile;
    File root_dir;
    JpegEncoder jpg;
    int i;
    int Quality = 90;
    boolean haveInputImage = false;
    String comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
    String inFileName = null;
    String outFileName = null;
    String secret_message = null;
    DCTSteganography steganograph;

    public Embed(Activity a, String inFileName, String secret_message, DCTSteganography steganograph) {
        this(a, "F5Android", inFileName, null, secret_message, steganograph);
    }

    public Embed(Activity a, String dump_dir, String inFileName, String secret_message, DCTSteganography steganograph) {
        this(a, dump_dir, inFileName, null, secret_message, steganograph);
        this.secret_message = secret_message;
    }

    public Embed(Activity a, String dump_dir, String inFileName, String outFileName, String secret_message, DCTSteganography steganograph) {
        this.a = a;
        this.inFileName = inFileName;
        Log.d((String)"***** JPEG-STEGO ******", (String)this.inFileName);
        this.file = new File(this.inFileName);
        this.steganograph = steganograph;
        this.root_dir = new File(Environment.getExternalStorageDirectory(), dump_dir);
        if (!this.root_dir.exists()) {
            this.root_dir.mkdir();
        }
        if (outFileName == null) {
            String extension = this.file.getName().substring(this.file.getName().lastIndexOf(".") - 1);
            this.outFile = new File(this.root_dir, this.file.getName().replace(extension, "_embed.jpg"));
            this.outFileName = this.outFile.getAbsolutePath();
        } else {
            this.outFileName = outFileName;
            this.outFile = new File(outFileName);
        }
        this.i = 1;
        Log.d((String)"***** JPEG-STEGO ******", (String)(this.root_dir + this.outFile.getName()));
        while (this.outFile.exists()) {
            String filename = this.outFile.getName().substring(0, this.outFile.getName().lastIndexOf(".")) + "_" + this.i++ + ".jpg";
            Log.d((String)"***** JPEG-STEGO ******", (String)("output filename: " + filename));
            this.outFile = new File(this.root_dir, filename);
            if (this.i <= 100) continue;
            return;
        }
        if (this.file.exists()) {
            Log.d((String)"***** JPEG-STEGO ******", (String)"this.file.exists, yay");
            try {
                this.dataOut = new FileOutputStream(this.outFile);
            }
            catch (IOException filename) {
                // empty catch block
            }
            this.image = BitmapFactory.decodeFile((String)this.inFileName);
            this.jpg = new JpegEncoder(this.image, this.Quality, this.dataOut, this.comment, this.steganograph);
            try {
                if (this.jpg.Compress(new ByteArrayInputStream(Base64.decode((String)secret_message, (int)2)))) {
                    ((EmbedListener)a).onEmbedded(this.outFile);
                }
            }
            catch (Exception e) {
                Log.e((String)"***** JPEG-STEGO ******", (String)e.toString());
                e.printStackTrace();
            }
            try {
                this.dataOut.close();
                Embed.addImageToGallery(this.outFile.getAbsolutePath(), (Context)this.a);
            }
            catch (IOException e) {
                Log.e((String)"***** JPEG-STEGO ******", (String)e.toString());
                e.printStackTrace();
            }
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)"finished EMBED");
    }

    public static void addImageToGallery(String filePath, Context context) {
        ContentValues values = new ContentValues();
        values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        values.put("mime_type", "image/jpeg");
        values.put("_data", filePath);
        context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
    }

    public static interface EmbedListener {
        public void onEmbedded(File var1);
    }
}

