/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.f5android;

import android.util.Log;
import java.nio.ByteBuffer;

public class F5Buffers {
    public static final String LOG = "************** PK JNI WRAPPER **************";
    private ByteBuffer f5;
    private ByteBuffer coeffs;
    private ByteBuffer buffer;

    public native ByteBuffer initImage(int[] var1, int[] var2, int[] var3);

    public native ByteBuffer initCoeffs(int var1);

    public native ByteBuffer initHuffmanBuffer(int var1);

    public native void setPixelValues(ByteBuffer var1, int[] var2, int var3, int var4);

    public native int getPixelValue(ByteBuffer var1, int var2);

    public native void setYValues(ByteBuffer var1, float var2, int var3, int var4);

    public native float getYValue(ByteBuffer var1, int var2, int var3);

    public native void setCr1Values(ByteBuffer var1, float var2, int var3, int var4);

    public native float getCr1Value(ByteBuffer var1, int var2, int var3);

    public native void setCb1Values(ByteBuffer var1, float var2, int var3, int var4);

    public native float getCb1Value(ByteBuffer var1, int var2, int var3);

    public native void setCr2Values(ByteBuffer var1, float var2, int var3, int var4);

    public native float getCr2Value(ByteBuffer var1, int var2, int var3);

    public native void setCb2Values(ByteBuffer var1, float var2, int var3, int var4);

    public native float getCb2Value(ByteBuffer var1, int var2, int var3);

    public native void setCoeffValues(ByteBuffer var1, int[] var2, int var3, int var4);

    public native int getCoeffValue(ByteBuffer var1, int var2);

    public native void setHuffmanBufferValues(ByteBuffer var1, int[] var2, int var3, int var4);

    public native int getHuffmanBufferValue(ByteBuffer var1, int var2);

    public native void cleanUpImage(ByteBuffer var1);

    public native void cleanUpCoeffs(ByteBuffer var1);

    public native void cleanUpHuffmanBuffer(ByteBuffer var1);

    public void initF5Image(int[] dimensions, int[] compWidth, int[] compHeight) {
        Log.d((String)LOG, (String)"initImage");
        this.f5 = this.initImage(dimensions, compWidth, compHeight);
    }

    public void initF5Coeffs(int size) {
        Log.d((String)LOG, (String)"initCoeffs");
        this.coeffs = this.initCoeffs(size);
    }

    public void initF5HuffmanBuffer(int size) {
        Log.d((String)LOG, (String)"initHuffmanBuffer");
        this.buffer = this.initHuffmanBuffer(size);
    }

    public void setPixelValues(int[] values, int start) {
        this.setPixelValues(this.f5, values, values.length, start);
    }

    public int getPixelValue(int pos) {
        return this.getPixelValue(this.f5, pos);
    }

    public void setYValues(float values, int x, int y) {
        this.setYValues(this.f5, values, x, y);
    }

    public float getYValue(int x, int y) {
        return this.getYValue(this.f5, x, y);
    }

    public void setCr1Values(float values, int x, int y) {
        this.setCr1Values(this.f5, values, x, y);
    }

    public float getCr1Value(int x, int y) {
        return this.getCr1Value(this.f5, x, y);
    }

    public void setCr2Values(float values, int x, int y) {
        this.setCr2Values(this.f5, values, x, y);
    }

    public float getCr2Value(int x, int y) {
        return this.getCr2Value(this.f5, x, y);
    }

    public void setCb1Values(float values, int x, int y) {
        this.setCb1Values(this.f5, values, x, y);
    }

    public float getCb1Value(int x, int y) {
        return this.getCb1Value(this.f5, x, y);
    }

    public void setCb2Values(float values, int x, int y) {
        this.setCb2Values(this.f5, values, x, y);
    }

    public float getCb2Value(int x, int y) {
        return this.getCb2Value(this.f5, x, y);
    }

    public void setCoeffValues(int[] values, int start) {
        this.setCoeffValues(this.coeffs, values, values.length, start);
    }

    public int getCoeffValue(int pos) {
        return this.getCoeffValue(this.coeffs, pos);
    }

    public void setHuffmanBufferValues(int[] values, int start) {
        this.setHuffmanBufferValues(this.buffer, values, values.length, start);
    }

    public int getHuffmanBufferValue(int pos) {
        return this.getHuffmanBufferValue(this.buffer, pos);
    }

    public void cleanUpImage() {
        Log.d((String)LOG, (String)"cleanup image");
        this.cleanUpImage(this.f5);
    }

    public void cleanUpCoeffs() {
        Log.d((String)LOG, (String)"cleanup coeffs");
        this.cleanUpCoeffs(this.coeffs);
    }

    public void cleanUpHuffmanBuffer() {
        Log.d((String)LOG, (String)"cleanup image");
        this.cleanUpHuffmanBuffer(this.buffer);
    }

    static {
        System.loadLibrary("F5Buffers");
    }
}

