/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsh;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzrx {
    private final ByteBuffer zzbij;

    private zzrx(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzrx(ByteBuffer byteBuffer) {
        this.zzbij = byteBuffer;
        this.zzbij.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzrx zzC(byte[] byArray) {
        return zzrx.zzb(byArray, 0, byArray.length);
    }

    public static zzrx zzb(byte[] byArray, int n, int n2) {
        return new zzrx(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzC(n, 1);
        this.zzj(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzC(n, 5);
        this.zzi(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzY(l);
    }

    public void zzy(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zzlH(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzC(n, 0);
        this.zzau(bl);
    }

    public void zzb(int n, String string2) throws IOException {
        this.zzC(n, 2);
        this.zzfz(string2);
    }

    public void zza(int n, zzse zzse2) throws IOException {
        this.zzC(n, 2);
        this.zzc(zzse2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzC(n, 2);
        this.zzD(byArray);
    }

    public void zzz(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zzlI(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzZ(l);
    }

    public void zzj(double d) throws IOException {
        this.zzae(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzlP(Float.floatToIntBits(f));
    }

    public void zzY(long l) throws IOException {
        this.zzac(l);
    }

    public void zzlH(int n) throws IOException {
        if (n >= 0) {
            this.zzlN(n);
        } else {
            this.zzac(n);
        }
    }

    public void zzau(boolean bl) throws IOException {
        this.zzlL(bl ? 1 : 0);
    }

    public void zzfz(String string2) throws IOException {
        try {
            int n = zzrx.zzlO(string2.length());
            int n2 = zzrx.zzlO(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzbij.position();
                if (this.zzbij.remaining() < n) {
                    throw new zza(n3 + n, this.zzbij.limit());
                }
                this.zzbij.position(n3 + n);
                zzrx.zza((CharSequence)string2, this.zzbij);
                int n4 = this.zzbij.position();
                this.zzbij.position(n3);
                this.zzlN(n4 - n3 - n);
                this.zzbij.position(n4);
            } else {
                this.zzlN(zzrx.zzc(string2));
                zzrx.zza((CharSequence)string2, this.zzbij);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzbij.position(), this.zzbij.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzc(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzrx.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzrx.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzrx.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c || c > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + n3);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzse zzse2) throws IOException {
        zzse2.zza(this);
    }

    public void zzc(zzse zzse2) throws IOException {
        this.zzlN(zzse2.zzFQ());
        zzse2.zza(this);
    }

    public void zzD(byte[] byArray) throws IOException {
        this.zzlN(byArray.length);
        this.zzF(byArray);
    }

    public void zzlI(int n) throws IOException {
        this.zzlN(zzrx.zzlQ(n));
    }

    public void zzZ(long l) throws IOException {
        this.zzac(zzrx.zzaf(l));
    }

    public static int zzb(int n, double d) {
        return zzrx.zzlM(n) + zzrx.zzk(d);
    }

    public static int zzc(int n, float f) {
        return zzrx.zzlM(n) + zzrx.zzj(f);
    }

    public static int zzd(int n, long l) {
        return zzrx.zzlM(n) + zzrx.zzaa(l);
    }

    public static int zzA(int n, int n2) {
        return zzrx.zzlM(n) + zzrx.zzlJ(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zzrx.zzlM(n) + zzrx.zzav(bl);
    }

    public static int zzn(int n, String string2) {
        return zzrx.zzlM(n) + zzrx.zzfA(string2);
    }

    public static int zzb(int n, zzse zzse2) {
        return zzrx.zzlM(n) * 2 + zzrx.zzd(zzse2);
    }

    public static int zzc(int n, zzse zzse2) {
        return zzrx.zzlM(n) + zzrx.zze(zzse2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzrx.zzlM(n) + zzrx.zzE(byArray);
    }

    public static int zzB(int n, int n2) {
        return zzrx.zzlM(n) + zzrx.zzlK(n2);
    }

    public static int zze(int n, long l) {
        return zzrx.zzlM(n) + zzrx.zzab(l);
    }

    public static int zzk(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzaa(long l) {
        return zzrx.zzad(l);
    }

    public static int zzlJ(int n) {
        if (n >= 0) {
            return zzrx.zzlO(n);
        }
        return 10;
    }

    public static int zzav(boolean bl) {
        return 1;
    }

    public static int zzfA(String string2) {
        int n = zzrx.zzc(string2);
        return zzrx.zzlO(n) + n;
    }

    public static int zzd(zzse zzse2) {
        return zzse2.zzFR();
    }

    public static int zze(zzse zzse2) {
        int n = zzse2.zzFR();
        return zzrx.zzlO(n) + n;
    }

    public static int zzE(byte[] byArray) {
        return zzrx.zzlO(byArray.length) + byArray.length;
    }

    public static int zzlK(int n) {
        return zzrx.zzlO(zzrx.zzlQ(n));
    }

    public static int zzab(long l) {
        return zzrx.zzad(zzrx.zzaf(l));
    }

    public int zzFD() {
        return this.zzbij.remaining();
    }

    public void zzFE() {
        if (this.zzFD() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzbij.hasRemaining()) {
            throw new zza(this.zzbij.position(), this.zzbij.limit());
        }
        this.zzbij.put(by);
    }

    public void zzlL(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzF(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzbij.remaining() < n2) {
            throw new zza(this.zzbij.position(), this.zzbij.limit());
        }
        this.zzbij.put(byArray, n, n2);
    }

    public void zzC(int n, int n2) throws IOException {
        this.zzlN(zzsh.zzD(n, n2));
    }

    public static int zzlM(int n) {
        return zzrx.zzlO(zzsh.zzD(n, 0));
    }

    public void zzlN(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzlL(n);
                return;
            }
            this.zzlL(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzlO(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzac(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzlL((int)l);
                return;
            }
            this.zzlL((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzad(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzlP(int n) throws IOException {
        if (this.zzbij.remaining() < 4) {
            throw new zza(this.zzbij.position(), this.zzbij.limit());
        }
        this.zzbij.putInt(n);
    }

    public void zzae(long l) throws IOException {
        if (this.zzbij.remaining() < 8) {
            throw new zza(this.zzbij.position(), this.zzbij.limit());
        }
        this.zzbij.putLong(l);
    }

    public static int zzlQ(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzaf(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

