/*
 * Decompiled with CFR 0.152.
 */
package james;

import android.util.Log;
import info.guardianproject.f5android.Extract;
import james.DCTSteganography;
import james.DCTStegoLSB;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;

public class DCTStegoEnvelopReduced
implements DCTSteganography {
    int n = 0;
    InputStream embeddedData;
    private static byte[] deZigZag = new byte[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private DCTStegoLSB steganograph = null;

    public void DCTStegoEnvelop() {
        this.steganograph = new DCTStegoLSB();
    }

    @Override
    public boolean loadKeyFromString(String s) {
        return true;
    }

    @Override
    public String generateStegoKeyString() {
        return "autobus";
    }

    @Override
    public void embed(int[] coeff, InputStream embeddedData) {
        int coeffCount = coeff.length;
        this.embeddedData = embeddedData;
        ArrayList<Integer> goodCoeffs = new ArrayList<Integer>(0);
        int _changed = 0;
        int _embedded = 0;
        int _examined = 0;
        int _expected = 0;
        boolean _large = false;
        int _thrown = 0;
        if (this.embeddedData != null) {
            block40: {
                int i;
                Log.d((String)"***** JPEG-STEGO ******", (String)"Permutation starts");
                F5Random random = new F5Random();
                Permutation permutation = new Permutation(coeffCount, random);
                int nextBitToEmbed = 0;
                int byteToEmbed = 0;
                int availableBitsToEmbed = 0;
                try {
                    byteToEmbed = this.embeddedData.available();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Log.d((String)"***** JPEG-STEGO ******", (String)("Embedding of " + (byteToEmbed * 8 + 32) + " bits (" + byteToEmbed + "+4 bytes) "));
                if (byteToEmbed > 0x7FFFFF) {
                    byteToEmbed = 0x7FFFFF;
                }
                for (i = 1; i < 8; ++i) {
                    this.n = (1 << i) - 1;
                    int usable = _expected * i / this.n - _expected * i / this.n % this.n;
                    if ((usable /= 8) == 0 || usable < byteToEmbed + 4) break;
                }
                int k = i - 1;
                this.n = (1 << k) - 1;
                switch (this.n) {
                    case 0: {
                        Log.d((String)"***** JPEG-STEGO ******", (String)"using default code, file will not fit");
                        ++this.n;
                        break;
                    }
                    case 1: {
                        Log.d((String)"***** JPEG-STEGO ******", (String)"using default code");
                        break;
                    }
                    default: {
                        Log.d((String)"***** JPEG-STEGO ******", (String)("using (1, " + this.n + ", " + k + ") code"));
                    }
                }
                byteToEmbed |= k << 24;
                byteToEmbed ^= random.getNextByte();
                byteToEmbed ^= random.getNextByte() << 8;
                byteToEmbed ^= random.getNextByte() << 16;
                nextBitToEmbed = (byteToEmbed ^= random.getNextByte() << 24) & 1;
                byteToEmbed >>= 1;
                availableBitsToEmbed = 31;
                ++_embedded;
                if (this.n > 1) {
                    int shuffledIndex;
                    int[] codeWord = new int[this.n];
                    int startOfN = 0;
                    int endOfN = 0;
                    boolean isLastByte = false;
                    for (i = 0; i < coeffCount; ++i) {
                        shuffledIndex = permutation.getShuffled(i);
                        if (shuffledIndex % 64 == 0 || coeff[shuffledIndex] == 0) continue;
                        if (coeff[shuffledIndex] > 0) {
                            goodCoeffs.add(shuffledIndex);
                            if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                                int n = shuffledIndex;
                                coeff[n] = coeff[n] - 1;
                                ++_changed;
                            }
                        } else {
                            goodCoeffs.add(shuffledIndex);
                            if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                                int n = shuffledIndex;
                                coeff[n] = coeff[n] + 1;
                                ++_changed;
                            }
                        }
                        if (coeff[shuffledIndex] != 0) {
                            if (availableBitsToEmbed == 0) break;
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            ++_embedded;
                            continue;
                        }
                        ++_thrown;
                    }
                    startOfN = i + 1;
                    do {
                        int kBitsToEmbed = 0;
                        for (i = 0; i < k; ++i) {
                            if (availableBitsToEmbed == 0) {
                                try {
                                    if (this.embeddedData.available() == 0) {
                                        isLastByte = true;
                                        break;
                                    }
                                    byteToEmbed = this.embeddedData.read();
                                    byteToEmbed ^= random.getNextByte();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
                                availableBitsToEmbed = 8;
                            }
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            kBitsToEmbed |= nextBitToEmbed << i;
                            ++_embedded;
                        }
                        do {
                            int j = startOfN;
                            i = 0;
                            while (i < this.n) {
                                if (j >= coeffCount) {
                                    Log.d((String)"***** JPEG-STEGO ******", (String)"Capacity exhausted.");
                                    break block40;
                                }
                                shuffledIndex = permutation.getShuffled(j);
                                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex] != 0) {
                                    codeWord[i++] = shuffledIndex;
                                }
                                ++j;
                            }
                            endOfN = j;
                            int hash = 0;
                            for (i = 0; i < this.n; ++i) {
                                int extractedBit = coeff[codeWord[i]] > 0 ? coeff[codeWord[i]] & 1 : 1 - (coeff[codeWord[i]] & 1);
                                if (extractedBit != 1) continue;
                                hash ^= i + 1;
                            }
                            i = hash ^ kBitsToEmbed;
                            if (i == 0) break;
                            if (coeff[codeWord[--i]] > 0) {
                                goodCoeffs.add(codeWord[i]);
                                int n = codeWord[i];
                                coeff[n] = coeff[n] - 1;
                            } else {
                                goodCoeffs.add(codeWord[i]);
                                int n = codeWord[i];
                                coeff[n] = coeff[n] + 1;
                            }
                            ++_changed;
                            if (coeff[codeWord[i]] != 0) continue;
                            goodCoeffs.remove(goodCoeffs.size() - 1);
                            ++_thrown;
                        } while (coeff[codeWord[i]] == 0);
                        startOfN = endOfN;
                    } while (!isLastByte);
                } else {
                    for (i = 0; i < coeffCount; ++i) {
                        int shuffledIndex = permutation.getShuffled(i);
                        if (shuffledIndex % 64 == 0 || coeff[shuffledIndex] == 0) continue;
                        ++_examined;
                        if (coeff[shuffledIndex] > 0) {
                            if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                                int n = shuffledIndex;
                                coeff[n] = coeff[n] - 1;
                                ++_changed;
                            }
                        } else if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                            int n = shuffledIndex;
                            coeff[n] = coeff[n] + 1;
                            ++_changed;
                        }
                        if (coeff[shuffledIndex] != 0) {
                            goodCoeffs.add(shuffledIndex);
                            if (availableBitsToEmbed == 0) {
                                try {
                                    if (this.embeddedData.available() == 0) break;
                                    byteToEmbed = this.embeddedData.read();
                                    byteToEmbed ^= random.getNextByte();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
                                availableBitsToEmbed = 8;
                            }
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            ++_embedded;
                            continue;
                        }
                        ++_thrown;
                    }
                }
            }
            if (_examined > 0) {
                Log.d((String)"***** JPEG-STEGO ******", (String)(_examined + " coefficients examined"));
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)(_changed + " coefficients changed (efficiency: " + _embedded / _changed + "." + _embedded * 10 / _changed % 10 + " bits per change)"));
            Log.d((String)"***** JPEG-STEGO ******", (String)(_thrown + " coefficients thrown (zeroed)"));
            Log.d((String)"***** JPEG-STEGO ******", (String)(_embedded + " bits (" + _embedded / 8 + " bytes) embedded"));
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("goodCoeffs length: %d", goodCoeffs.size()));
        }
    }

    @Override
    public void extract(int[] coeff, ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        int nBytesExtracted;
        int extractedFileLength;
        block21: {
            int extractedBit;
            Log.d((String)"***** JPEG-STEGO ******", (String)"Permutation starts");
            ArrayList<Integer> goodCoeffs = new ArrayList<Integer>(0);
            F5Random random = new F5Random();
            Permutation permutation = new Permutation(coeff.length, random);
            Log.d((String)"***** JPEG-STEGO ******", (String)(coeff.length + " indices shuffled"));
            int extractedByte = 0;
            int availableExtractedBits = 0;
            extractedFileLength = 0;
            nBytesExtracted = 0;
            int shuffledIndex = 0;
            Log.d((String)"***** JPEG-STEGO ******", (String)"Extraction starts");
            int i = 0;
            while (availableExtractedBits < 32) {
                shuffledIndex = permutation.getShuffled(i);
                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                    if (coeff[shuffledIndex] > 0) {
                        goodCoeffs.add(shuffledIndex);
                        extractedBit = coeff[shuffledIndex] & 1;
                    } else {
                        goodCoeffs.add(shuffledIndex);
                        extractedBit = 1 - (coeff[shuffledIndex] & 1);
                    }
                    extractedFileLength |= extractedBit << availableExtractedBits++;
                }
                ++i;
            }
            extractedFileLength ^= random.getNextByte();
            extractedFileLength ^= random.getNextByte() << 8;
            extractedFileLength ^= random.getNextByte() << 16;
            int k = (extractedFileLength ^= random.getNextByte() << 24) >> 24;
            int n = (1 << (k %= 32)) - 1;
            Log.d((String)"***** JPEG-STEGO ******", (String)("Length of embedded file: " + (extractedFileLength &= 0x7FFFFF) + " bytes"));
            availableExtractedBits = 0;
            if (n > 0) {
                int startOfN = i;
                Log.d((String)"***** JPEG-STEGO ******", (String)("(1, " + n + ", " + k + ") code used"));
                block1: while (true) {
                    int hash = 0;
                    int code = 1;
                    i = 0;
                    while (code <= n) {
                        if (startOfN + i < coeff.length) {
                            shuffledIndex = permutation.getShuffled(startOfN + i);
                            if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                                if (coeff[shuffledIndex] > 0) {
                                    goodCoeffs.add(shuffledIndex);
                                    extractedBit = coeff[shuffledIndex] & 1;
                                } else {
                                    goodCoeffs.add(shuffledIndex);
                                    extractedBit = 1 - (coeff[shuffledIndex] & 1);
                                }
                                if (extractedBit == 1) {
                                    hash ^= code;
                                }
                                ++code;
                            }
                            ++i;
                            continue;
                        }
                        break block21;
                    }
                    startOfN += i;
                    i = 0;
                    while (true) {
                        if (i >= k) continue block1;
                        extractedByte |= (hash >> i & 1) << availableExtractedBits++;
                        if (availableExtractedBits == 8) {
                            fos.write((byte)(extractedByte ^= random.getNextByte()));
                            extractedByte = 0;
                            availableExtractedBits = 0;
                            if (++nBytesExtracted == extractedFileLength) break block21;
                        }
                        ++i;
                    }
                    break;
                }
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)"Default code used");
            while (i < coeff.length) {
                shuffledIndex = permutation.getShuffled(i);
                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                    extractedBit = coeff[shuffledIndex] > 0 ? coeff[shuffledIndex] & 1 : 1 - (coeff[shuffledIndex] & 1);
                    extractedByte |= extractedBit << availableExtractedBits++;
                    if (availableExtractedBits == 8) {
                        fos.write((byte)(extractedByte ^= random.getNextByte()));
                        extractedByte = 0;
                        availableExtractedBits = 0;
                        if (++nBytesExtracted == extractedFileLength) break;
                    }
                }
                ++i;
            }
        }
        if (nBytesExtracted < extractedFileLength) {
            Log.d((String)"***** JPEG-STEGO ******", (String)("Incomplete file: only " + nBytesExtracted + " of " + extractedFileLength + " bytes extracted"));
        } else {
            Log.d((String)"***** JPEG-STEGO ******", (String)String.valueOf(fos));
            listener.onExtractionResult(fos);
        }
    }
}

