/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import sun.security.provider.NativeSeedGenerator;
import sun.security.provider.SunEntries;

abstract class SeedGenerator {
    private static SeedGenerator instance;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";

    SeedGenerator() {
    }

    public static void generateSeed(byte[] result) {
        instance.getSeedBytes(result);
    }

    void getSeedBytes(byte[] result) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getSeedByte();
        }
    }

    abstract byte getSeedByte();

    static byte[] getSystemEntropy() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        byte b = (byte)System.currentTimeMillis();
        md.update(b);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Properties p = System.getProperties();
                    Enumeration<?> e = p.propertyNames();
                    while (e.hasMoreElements()) {
                        String s = (String)e.nextElement();
                        md.update(s.getBytes());
                        md.update(p.getProperty(s).getBytes());
                    }
                    md.update(InetAddress.getLocalHost().toString().getBytes());
                    File f = new File(p.getProperty("java.io.tmpdir"));
                    String[] sa = f.list();
                    for (int i = 0; i < sa.length; ++i) {
                        md.update(sa[i].getBytes());
                    }
                }
                catch (Exception ex) {
                    md.update((byte)ex.hashCode());
                }
                Runtime rt = Runtime.getRuntime();
                byte[] memBytes = SeedGenerator.longToByteArray(rt.totalMemory());
                md.update(memBytes, 0, memBytes.length);
                memBytes = SeedGenerator.longToByteArray(rt.freeMemory());
                md.update(memBytes, 0, memBytes.length);
                return null;
            }
        });
        return md.digest();
    }

    private static byte[] longToByteArray(long l) {
        byte[] retVal = new byte[8];
        for (int i = 0; i < 8; ++i) {
            retVal[i] = (byte)l;
            l >>= 8;
        }
        return retVal;
    }

    static {
        String egdSource = SunEntries.getSeedSource();
        if (egdSource.equals(URL_DEV_RANDOM) || egdSource.equals(URL_DEV_URANDOM)) {
            try {
                instance = new NativeSeedGenerator();
            }
            catch (IOException iOException) {}
        } else if (egdSource.length() != 0) {
            try {
                instance = new URLSeedGenerator(egdSource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (instance == null) {
            instance = new ThreadedSeedGenerator();
        }
    }

    static class URLSeedGenerator
    extends SeedGenerator {
        private String deviceName;
        private BufferedInputStream devRandom;

        URLSeedGenerator(String egdurl) throws IOException {
            if (egdurl == null) {
                throw new IOException("No random source specified");
            }
            this.deviceName = egdurl;
            this.init();
        }

        URLSeedGenerator() throws IOException {
            this(SeedGenerator.URL_DEV_RANDOM);
        }

        private void init() throws IOException {
            final URL device = new URL(this.deviceName);
            this.devRandom = AccessController.doPrivileged(new PrivilegedAction<BufferedInputStream>(){

                @Override
                public BufferedInputStream run() {
                    try {
                        return new BufferedInputStream(device.openStream());
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
            });
            if (this.devRandom == null) {
                throw new IOException("failed to open " + device);
            }
        }

        @Override
        byte getSeedByte() {
            int stat;
            byte[] b = new byte[1];
            try {
                stat = this.devRandom.read(b, 0, b.length);
            }
            catch (IOException ioe) {
                throw new InternalError("URLSeedGenerator " + this.deviceName + " generated exception: " + ioe.getMessage());
            }
            if (stat == b.length) {
                return b[0];
            }
            if (stat == -1) {
                throw new InternalError("URLSeedGenerator " + this.deviceName + " reached end of file");
            }
            throw new InternalError("URLSeedGenerator " + this.deviceName + " failed read");
        }
    }

    private static class ThreadedSeedGenerator
    extends SeedGenerator
    implements Runnable {
        private byte[] pool = new byte[20];
        private int start = 0;
        private int end = 0;
        private int count;
        ThreadGroup seedGroup;
        private static byte[] rndTab = new byte[]{56, 30, -107, -6, -86, 25, -83, 75, -12, -64, 5, -128, 78, 21, 16, 32, 70, -81, 37, -51, -43, -46, -108, 87, 29, 17, -55, 22, -11, -111, -115, 84, -100, 108, -45, -15, -98, 72, -33, -28, 31, -52, -37, -117, -97, -27, 93, -123, 47, 126, -80, -62, -93, -79, 61, -96, -65, -5, -47, -119, 14, 89, 81, -118, -88, 20, 67, -126, -113, 60, -102, 55, 110, 28, 85, 121, 122, -58, 2, 45, 43, 24, -9, 103, -13, 102, -68, -54, -101, -104, 19, 13, -39, -26, -103, 62, 77, 51, 44, 111, 73, 18, -127, -82, 4, -30, 11, -99, -74, 40, -89, 42, -76, -77, -94, -35, -69, 35, 120, 76, 33, -73, -7, 82, -25, -10, 88, 125, -112, 58, 83, 95, 6, 10, 98, -34, 80, 15, -91, 86, -19, 52, -17, 117, 49, -63, 118, -90, 36, -116, -40, -71, 97, -53, -109, -85, 109, -16, -3, 104, -95, 68, 54, 34, 26, 114, -1, 106, -121, 3, 66, 0, 100, -84, 57, 107, 119, -42, 112, -61, 1, 48, 38, 12, -56, -57, 39, -106, -72, 41, 7, 71, -29, -59, -8, -38, 79, -31, 124, -124, 8, 91, 116, 99, -4, 9, -36, -78, 63, -49, -67, -87, 59, 101, -32, 92, 94, 53, -41, 115, -66, -70, -122, 50, -50, -22, -20, -18, -21, 23, -2, -48, 96, 65, -105, 123, -14, -110, 69, -24, -120, -75, 74, 127, -60, 113, 90, -114, 105, 46, 27, -125, -23, -44, 64};

        ThreadedSeedGenerator() {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("internal error: SHA-1 not available.");
            }
            final ThreadGroup[] finalsg = new ThreadGroup[1];
            Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    ThreadGroup parent;
                    ThreadGroup group = Thread.currentThread().getThreadGroup();
                    while ((parent = group.getParent()) != null) {
                        group = parent;
                    }
                    finalsg[0] = new ThreadGroup(group, "SeedGenerator ThreadGroup");
                    Thread newT = new Thread(finalsg[0], ThreadedSeedGenerator.this, "SeedGenerator Thread");
                    newT.setPriority(1);
                    newT.setDaemon(true);
                    return newT;
                }
            });
            this.seedGroup = finalsg[0];
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final void run() {
            try {
                while (true) {
                    int latch;
                    ThreadedSeedGenerator threadedSeedGenerator = this;
                    // MONITORENTER : threadedSeedGenerator
                    while (this.count >= this.pool.length) {
                        this.wait();
                    }
                    // MONITOREXIT : threadedSeedGenerator
                    byte v = 0;
                    int quanta = 0;
                    for (int counter = 0; counter < 64000 && quanta < 6; counter += latch, ++quanta) {
                        try {
                            BogusThread bt = new BogusThread();
                            Thread t = new Thread(this.seedGroup, bt, "SeedGenerator Thread");
                            t.start();
                        }
                        catch (Exception e) {
                            throw new InternalError("internal error: SeedGenerator thread creation error.");
                        }
                        latch = 0;
                        latch = 0;
                        long l = System.currentTimeMillis() + 250L;
                        while (System.currentTimeMillis() < l) {
                            ThreadedSeedGenerator threadedSeedGenerator2 = this;
                            // MONITORENTER : threadedSeedGenerator2
                            // MONITOREXIT : threadedSeedGenerator2
                            ++latch;
                        }
                        v = (byte)(v ^ rndTab[latch % 255]);
                    }
                    ThreadedSeedGenerator threadedSeedGenerator3 = this;
                    // MONITORENTER : threadedSeedGenerator3
                    this.pool[this.end] = v;
                    ++this.end;
                    ++this.count;
                    if (this.end >= this.pool.length) {
                        this.end = 0;
                    }
                    this.notifyAll();
                    // MONITOREXIT : threadedSeedGenerator3
                }
            }
            catch (Exception e) {
                throw new InternalError("internal error: SeedGenerator thread generated an exception.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte getSeedByte() {
            ThreadedSeedGenerator threadedSeedGenerator;
            byte b;
            block10: {
                b = 0;
                try {
                    threadedSeedGenerator = this;
                    synchronized (threadedSeedGenerator) {
                        while (this.count <= 0) {
                            this.wait();
                        }
                    }
                }
                catch (Exception e) {
                    if (this.count > 0) break block10;
                    throw new InternalError("internal error: SeedGenerator thread generated an exception.");
                }
            }
            threadedSeedGenerator = this;
            synchronized (threadedSeedGenerator) {
                b = this.pool[this.start];
                this.pool[this.start] = 0;
                ++this.start;
                --this.count;
                if (this.start == this.pool.length) {
                    this.start = 0;
                }
                this.notifyAll();
            }
            return b;
        }

        private static class BogusThread
        implements Runnable {
            private BogusThread() {
            }

            @Override
            public final void run() {
                try {
                    for (int i = 0; i < 5; ++i) {
                        Thread.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

