package io.github.japdlsd.steganogram;

import android.util.Log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * Created by askar on 25.4.2016.
 */
public class GZIPCompression implements Compression {
    //based on : http://stackoverflow.com/questions/6717165/how-can-i-zip-and-unzip-a-string-using-gzipoutputstream-that-is-compatible-with

    public byte[] compress (byte[] message) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(message.length);
            GZIPOutputStream gos = new GZIPOutputStream(os);
            gos.write(message);
            gos.close();
            byte[] compressed = os.toByteArray();
            os.close();
            return compressed;
        }
        catch (Exception e) {
            // @TODO correct handling
            Log.e("myApp", "nieco sa pokazilo pri comressii");
        }
        return null;
    }

    public byte[] decompress (byte[] message) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(message);
            final int BUFFER_SIZE = 32;

            GZIPInputStream gis = new GZIPInputStream(is, BUFFER_SIZE);
            byte[] buffer = new byte[BUFFER_SIZE];

            ArrayList<Byte> a = new ArrayList<>(0);

            int bytesRead;
            while ((bytesRead = gis.read(buffer)) != -1) {
                for (int i = 0; i < bytesRead; i++) {
                    a.add(buffer[i]);
                }
            }

            byte[] res = new byte[a.size()];
            for (int i = 0; i < a.size(); i++) {
                res[i] = a.get(i);
            }

            return res;

//            final int BUFFER_SIZE = 32;
//            ByteArrayInputStream is = new ByteArrayInputStream(message);
//            GZIPInputStream gis = new GZIPInputStream(is, BUFFER_SIZE);
//            StringBuilder string = new StringBuilder();
//            byte[] data = new byte[BUFFER_SIZE];
//            int bytesRead;
//            while ((bytesRead = gis.read(data)) != -1) {
//                string.append(new String(data, 0, bytesRead));
//            }
//            gis.close();
//            is.close();
//            return string.toString();
        }
        catch (Exception e) {
            // @TODO correct handling
            Log.e("myApp", "nieco sa pokazilo pri decomressii");
        }
        return null;
    }
}
