package io.github.japdlsd.steganogram;

import android.app.AlertDialog;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.support.v4.app.DialogFragment;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.content.Intent;

public class MainActivity extends AppCompatActivity {


    public void startEmbedMessageActivity(View view) {
        Intent intent = new Intent(this, EmbedMessageActivity.class);
        startActivity(intent);
    }

    public void startExtractMessageActivity(View view) {
        Intent intent = new Intent(this, ExtractMessageActivity.class);
        startActivity(intent);
    }

    public void startSettingsActivity(View view) {
        Intent intent = new Intent(this, SettingsActivity.class);
        startActivity(intent);
    }

    public void startHelpActivity(View view) {
        Intent intent = new Intent(this, HelpActivity.class);
        startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // checking if keys are generated
        // shouldn't be there on te first run
        Context context = this;
        //SharedPreferences sharedPref = context.getSharedPreferences(
        //        getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);
        String stegokey = sharedPref.getString(getString(R.string.stegokey), null);
        if (stegokey == null) {
            Log.d("myApp", "stego key is not saved, generetate one");
            SharedPreferences.Editor editor = sharedPref.edit();
            Solution sol = new Solution(this);
            String key = sol.steganograph.generateStegoKeyString();

            editor.putString(getString(R.string.stegokey), key);
            editor.commit();
        }
        else {
            Log.d("myApp", "stegokey: " + stegokey);
        }

        String cryptokey = sharedPref.getString(getString(R.string.cryptokey), null);
        if (cryptokey == null) {
            Log.d("myApp", "crypto key is not saved, generate one");
            SharedPreferences.Editor editor = sharedPref.edit();
            Solution sol = new Solution(this);
            String key = sol.encryptor.generateCryptoKeyString();

            editor.putString(getString(R.string.cryptokey), key);
            editor.commit();
        }
        else {
            Log.d("myApp", "cryptokey: " + cryptokey);
        }


    }

    @Override
    public void onDestroy () {
        super.onDestroy();
        Log.w("myApp", "onDestroy");
    }
}
