package io.github.japdlsd.steganogram;

import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;

public class SettingsActivity extends AppCompatActivity {
    public void saveCryptoKey(View view) {
        EditText field = (EditText) findViewById(R.id.cryptoKeyField);
        String newKey = String.valueOf(field.getText());

        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);

        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(getString(R.string.cryptokey), newKey);
        editor.commit();
    }

    public void saveStegoKey(View view) {
        EditText field = (EditText) findViewById(R.id.stegoKeyField);
        String newKey = String.valueOf(field.getText());

        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);

        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(getString(R.string.stegokey), newKey);
        editor.commit();
    }

    public void showStegoKey () {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);
        String stegokey = sharedPref.getString(getString(R.string.stegokey), null);

        EditText stegoField = (EditText) findViewById(R.id.stegoKeyField);
        stegoField.setText(stegokey);
    }

    public void showCryptoKey () {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);
        String cryptokey = sharedPref.getString(getString(R.string.cryptokey), null);

        EditText cryptoField = (EditText) findViewById(R.id.cryptoKeyField);
        cryptoField.setText(cryptokey);
    }

    public void regenerateCryptoKey(View view) {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);

        SharedPreferences.Editor editor = sharedPref.edit();
        Solution sol = new Solution(this);
        String key = sol.encryptor.generateCryptoKeyString();

        editor.putString(getString(R.string.cryptokey), key);
        editor.commit();

        this.showCryptoKey();
    }

    public void regenerateStegoKey(View view) {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);

        SharedPreferences.Editor editor = sharedPref.edit();
        Solution sol = new Solution(this);
        String key = sol.steganograph.generateStegoKeyString();

        editor.putString(getString(R.string.stegokey), key);
        editor.commit();

        this.showStegoKey();
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);
        String stegokey = sharedPref.getString(getString(R.string.stegokey), null);
        String cryptokey = sharedPref.getString(getString(R.string.cryptokey), null);


        EditText cryptoField = (EditText) findViewById(R.id.cryptoKeyField);
        cryptoField.setText(cryptokey);

        EditText stegoField = (EditText) findViewById(R.id.stegoKeyField);
        stegoField.setText(stegokey);

    }
}
