package io.github.japdlsd.steganogram;

import android.app.Activity;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;

import info.guardianproject.f5android.Embed;
import info.guardianproject.f5android.Extract;
import james.DCTSteganography;
import james.DCTStegoCERep;
import james.Jpeg;

/**
 * Created by askar on 26.3.2016.
 */
public class Solution {
    public Compression compressor;
    public SymmetricEncryption encryptor;
    public DCTSteganography steganograph;

    public Uri coverImageUri;

    public Activity parentActivity;

    // SINGLETON {{{
    /*static private Solution uniqueInstance = null;

    private Solution (Compressor compressor, SymmetricEncryption encryptor, DCTSteganography steganograph) {
        // @TODO
        this.compressor = compressor;
        this.encryptor = encryptor;
        this.steganograph = steganograph;
    }

    public static Solution getUniqueInstance () {
        if (Solution.uniqueInstance == null) {
            // @TODO plug serious libraries
            Compressor compressor = new DummyCompression();
            SymmetricEncryption encryptor = new DummySymmetricEncrytpion();
            DCTSteganography steganograph = new DummyDCTSteganography();

            Solution.uniqueInstance = new Solution(compressor, encryptor, steganograph);
        }
        return Solution.uniqueInstance;
    }
    */
    // }}}

    public Solution (Activity a) {
        this(   a,
                new GZIPCompression(),
                new AESEncryption(),
                new DCTStegoCERep()
        );
    }

    private Solution (Activity a, Compression compressor, SymmetricEncryption encryptor, DCTSteganography steganograph) {
        this.parentActivity = a;
        this.compressor = compressor;
        this.encryptor = encryptor;
        this.steganograph = steganograph;
    }

    public void loadCryptoKey () {
        // @TODO load crypto key from internal memory
        Log.d("myApp", "loadCryptoKey()");
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this.parentActivity);
        String cryptoKeyRaw = sharedPref.getString(this.parentActivity.getString(R.string.cryptokey), null);
        this.encryptor.loadKeyFromString(cryptoKeyRaw);
    }

    public void loadStegoKey () {
        // @TODO load stego key form internal memory
        Log.d("myApp", "loadStegoKey()");
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this.parentActivity);
        String stegoKeyRaw = sharedPref.getString(this.parentActivity.getString(R.string.stegokey), null);
        this.steganograph.loadKeyFromString(stegoKeyRaw);
    }

    public void loadImageFromUri (Uri uri) {
        // @TODO load image from internal memory by Uri
        Log.d("myApp", "loadImageFromUri()");
        this.coverImageUri = uri;
        
    }

    public void embedMessage (String message) {
        // @TODO custom output file name
        // @TODO embedding process
        Log.d("myApp", "embedMessage()");

        try {
            Log.d(Jpeg.LOG, "message: " + message);

            byte[] text = message.getBytes("UTF-8");
            { // debug
                String s = "";
                for (int i = 0; i < text.length; i++) {
                    s += String.valueOf(text[i]) + " ";
                }
                Log.d(Jpeg.LOG, "text: " + s);
            }

            byte[] compressedText = this.compressor.compress(text);
            { // debug
                String s = "";
                for (int i = 0; i < compressedText.length; i++) {
                    s += String.valueOf(compressedText[i]) + " ";
                }
                Log.d(Jpeg.LOG, "compressedText: " + s);
            }

            this.loadCryptoKey();
            byte[] encryptedText = this.encryptor.encrypt(compressedText);
            { // debug
                String s = "";
                for (int i = 0; i < encryptedText.length; i++) {
                    s += String.valueOf(encryptedText[i]) + " ";
                }
                Log.d(Jpeg.LOG, "encryptedText: " + s);
            }

            this.loadStegoKey();

            // {{{ POKUS
            try {
                String t64 = Base64.encodeToString(encryptedText, Base64.NO_WRAP);
                Log.d(Jpeg.LOG, "t64: \"" + t64 + "\"" + "; length: " + String.valueOf(t64.length()));
                Embed embed = new Embed(
                        this.parentActivity,
                        Environment.DIRECTORY_PICTURES,
                        this.coverImageUri.toString().substring(5),
                        t64,
                        this.steganograph
                );

                Log.w("myApp", "Dokoncil som pokus");
            }
            catch (Exception e) {
                Log.w("myApp", "nieco sa pokazilo v module");
                Log.w("myApp", e.toString());
            }

            // }}}
        }
        catch (UnsupportedEncodingException e) {
            // @TODO create correct error messaging
            e.printStackTrace();
        }
    }

    class ExtractionCatcher implements Extract.ExtractionListener {
        byte[] res = null;
        Solution sol = null;

        public ExtractionCatcher (Solution sol) {
            this.sol = sol;
        }

        public void onExtractionResult (ByteArrayOutputStream fos) {
            try {
                Log.d(Jpeg.LOG, "fos: " + String.valueOf(fos));

                this.res = fos.toByteArray();
//                {
//                    String s = "";
//                    for (int i = 0; i < this.res.length; i++) {
//                        s += String.valueOf(this.res[i]) + " ";
//                    }
//                    Log.d(Jpeg.LOG, "this.res: " + s);
//                }
//
//                String res2 = new String(this.res, "UTF-8");
//                Log.d(Jpeg.LOG, "res2 " + res2);

                //byte[] encryptedText = Base64.decode(res2, Base64.NO_WRAP);
                byte[] encryptedText = res;
                {
                    String s = "";
                    for (int i = 0; i < encryptedText.length; i++) {
                        s += String.valueOf(encryptedText[i]) + " ";
                    }
                    Log.d(Jpeg.LOG, "encryptedText: " + s);
                }

                this.sol.loadCryptoKey();
                byte[] compressedText = this.sol.encryptor.decrypt(encryptedText);
                {
                    String s = "";
                    for (int i = 0; i < compressedText.length; i++) {
                        s += String.valueOf(compressedText[i]) + " ";
                    }
                    Log.d(Jpeg.LOG, "compressedText: " + s);
                }

                byte[] text = this.sol.compressor.decompress(compressedText);
                {
                    String s = "";
                    for (int i = 0; i < text.length; i++) {
                        s += String.valueOf(text[i]) + " ";
                    }
                    Log.d(Jpeg.LOG, "text: " + s);
                }

                String message = new String(text, "UTF-8");
                Log.d(Jpeg.LOG, "message: " + message);

                ((ExtractionStringListener) this.sol.parentActivity).onExtractionResult(message);
            }
            catch (Exception e) {
                Log.e("myApp", e.toString());
            }
        }
    }

    public interface ExtractionStringListener {
        public void onExtractionResult (String result);
    }

    private String getRealPathFromURI(Uri contentURI) {
        String result;
        Cursor cursor = this.parentActivity.getContentResolver().query(contentURI, null, null, null, null);
        if (cursor == null) { // Source is Dropbox or other similar local file path
            result = contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int idx = cursor.getColumnIndex(MediaStore.Images.ImageColumns.DATA);
            result = cursor.getString(idx);
            cursor.close();
        }
        return result;
    }

    public void extractMessageWithCallback (ExtractionStringListener a) {
        Log.d("myApp", "extractMessageWithCallback()");
        ExtractionCatcher catcher = new ExtractionCatcher(this);

        this.loadStegoKey();

        Extract extract = new Extract(
                catcher,
                getRealPathFromURI(this.coverImageUri),
                this.steganograph
        );
    }

/*    public String extractMessage () {
       // @TODO extracting process
        Log.d("myApp", "extractMessage()");
        try {
            // ...
            this.loadStegoKey();
            DCTcoefs changedCoefs = null; // @TODO


            File file = new File(this.coverImageUri.getPath());
            String path = file.getAbsolutePath();
            try {

            } catch (Exception e) {
                Log.w("myApp", "nieco sa zrubalo pri extrakcii");
                Log.w("myApp", e.toString());
            }


            this.loadCryptoKey();
            byte[] encryptedText = this.steganograph.extract(changedCoefs);
            byte[] compressedText = this.encryptor.decrypt(encryptedText);
            byte[] text = this.compressor.decompress(compressedText);
            String message = new String(text, "UTF-8");
            return message;
        } catch (UnsupportedEncodingException e) {
            // @TODO create correct error messaging
            e.printStackTrace();
        }
        return ""; // @TODO create correct error messaging
    }*/

    public void saveImageWithName (String filename) {
        // @TODO save modified message to external memory
        Log.d("myApp", "saveImageWithName()");
    }
}
