package info.guardianproject.f5android;

import james.DCTSteganography;
import james.Jpeg;
import james.JpegEncoder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;

public class Embed {
	Activity a;
	Bitmap image = null;
	FileOutputStream dataOut = null;
    File file, outFile, root_dir;
    JpegEncoder jpg;
    int i, Quality = 90;
    // Check to see if the input file name has one of the extensions:
    // .tif, .gif, .jpg
    // If not, print the standard use info.
    boolean haveInputImage = false;
    String comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
    String inFileName = null;
    String outFileName = null;
    String secret_message = null;

	DCTSteganography steganograph;

    public interface EmbedListener {
    	public void onEmbedded(File outFile);
    }
    
    public Embed(Activity a, String inFileName, String secret_message, DCTSteganography steganograph) {
    	this(a, "F5Android", inFileName, null, secret_message, steganograph);
    }
    
    public Embed(Activity a, String dump_dir, String inFileName, String secret_message, DCTSteganography steganograph) {
    	this(a, dump_dir, inFileName, null, secret_message, steganograph);
    	
    	this.secret_message = secret_message;
    }
    
    public Embed(Activity a, String dump_dir, String inFileName, String outFileName, String secret_message, DCTSteganography steganograph) {
    	this.a = a;
    	this.inFileName = inFileName;
		Log.d(Jpeg.LOG, this.inFileName);
    	this.file = new File(this.inFileName);

		this.steganograph = steganograph;

    	root_dir = new File(Environment.getExternalStorageDirectory(), dump_dir);
    	if(!root_dir.exists())
    		root_dir.mkdir();
    	
    	if(outFileName == null) {
    		String extension = this.file.getName().substring(this.file.getName().lastIndexOf(".") - 1);
    		this.outFile = new File(root_dir, this.file.getName().replace(extension, "_embed.jpg"));
    		this.outFileName = this.outFile.getAbsolutePath();
    	} else {
    		this.outFileName = outFileName;
    		this.outFile = new File(outFileName);
    	}
    	    	
    	i = 1;
		Log.d(Jpeg.LOG, root_dir + this.outFile.getName());
    	while(outFile.exists()) {
			final String filename = outFile.getName().substring(0, outFile.getName().lastIndexOf(".")) + "_" + i++ + ".jpg";
			Log.d(Jpeg.LOG, "output filename: " + filename);
    		this.outFile = new File(root_dir, filename);
    		if(i > 100)
    			return;
    	}
    	
    	if(this.file.exists()) {
			Log.d(Jpeg.LOG, "this.file.exists, yay");
    		try {
    			dataOut = new FileOutputStream(outFile);
    		} catch(final IOException e) {}
    		
    		image = BitmapFactory.decodeFile(this.inFileName);
    		jpg = new JpegEncoder(image, Quality, dataOut, comment, this.steganograph);
    		
    		try {
				if(jpg.Compress(new ByteArrayInputStream(Base64.decode(secret_message, Base64.NO_WRAP)))) {
    			//if(jpg.Compress(new ByteArrayInputStream(secret_message.getBytes("UTF-8")))) {
    				((EmbedListener) a).onEmbedded(outFile);
    			}
    		} catch(final Exception e) {
    			Log.e(Jpeg.LOG, e.toString());
    			e.printStackTrace();
    		}
    		
    		try {
    			dataOut.close();
				addImageToGallery(outFile.getAbsolutePath(), this.a);
    		} catch(final IOException e) {
    			Log.e(Jpeg.LOG, e.toString());
    			e.printStackTrace();
    		}
    	}

		Log.d(Jpeg.LOG, "finished EMBED");
    	
    }

	public static void addImageToGallery(final String filePath, final Context context) {

		ContentValues values = new ContentValues();

		values.put(MediaStore.Images.Media.DATE_TAKEN, System.currentTimeMillis());
		values.put(MediaStore.Images.Media.MIME_TYPE, "image/jpeg");
		values.put(MediaStore.MediaColumns.DATA, filePath);

		context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
	}
	
}
