package info.guardianproject.f5android;

import james.DCTSteganography;
import james.DCTStegoCE;
import james.DCTStegoCEOld;
import james.DCTStegoCERep;
import james.DCTStegoEnvelop;
import james.DCTStegoEnvelopReduced;
import james.DCTStegoLSB;
import james.Jpeg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import android.util.Log;

import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;
import net.f5.ortega.HuffmanDecode;


public class Extract {
    private File f; // carrier file
    //private Activity a;
    private ExtractionListener listener;

    private byte[] carrier; // carrier data

    private int[] coeff; // dct values

    private ByteArrayOutputStream fos; // embedded file (output file)

    private static byte[] deZigZag = {
            0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31,
            40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61,
            35, 36, 48, 49, 57, 58, 62, 63 };

    DCTSteganography steganograph;

    public interface ExtractionListener {
    	public void onExtractionResult(ByteArrayOutputStream baos);
    }


    public Extract (ExtractionListener listener, String f, DCTSteganography steganograph) {
        this(listener, new File(f), steganograph);
    }

    public Extract (ExtractionListener listener, File f, DCTSteganography steganograph) {
        this.steganograph = steganograph;
        fos = new ByteArrayOutputStream();
        this.f = f;
        this.listener = listener;

        try {
            final FileInputStream fis = new FileInputStream(this.f);
            extract(fis, (int) f.length(), fos);
        } catch (IOException e) {
            Log.e(Jpeg.LOG, e.toString());
            e.printStackTrace();
        }
    }

    /*
    public Extract(Activity a, String f) {
    	this(a, new File(f));
    }
    
    public Extract(Activity a, File f) {
    	fos = new ByteArrayOutputStream();
    	this.f = f;
    	this.a = a;
    	
    	try {
    		final FileInputStream fis = new FileInputStream(this.f);
			extract(fis, (int) f.length(), fos);
		} catch (IOException e) {
			Log.e(Jpeg.LOG, e.toString());
			e.printStackTrace();
		}
    }*/

    public void extract(InputStream fis, int flength, ByteArrayOutputStream fos)
            throws IOException {
        carrier = new byte[flength];
        fis.read(carrier);
        final HuffmanDecode hd = new HuffmanDecode(carrier);
        Log.d(Jpeg.LOG, "Huffman decoding starts");
        coeff = hd.decode();

        int[] deZigZagCoeff = new int[coeff.length];
        for (int i = 0; i < coeff.length; i++) {
            deZigZagCoeff[i] = coeff[i - i%64 + deZigZag[i%64]];
        }

        // {{{ stego starts
        //DCTStegoEnvelop stego = new DCTStegoEnvelop();
        //stego.extract(coeff, fos, this.listener);

        //DCTStegoEnvelopReduced stego = new DCTStegoEnvelopReduced();
        //stego.extract(coeff, fos, this.listener);

        //DCTStegoLSB stego = new DCTStegoLSB();
        //stego.extract(deZigZagCoeff, fos, this.listener);

        //DCTStegoCE stego = new DCTStegoCE();
        //stego.extract(deZigZagCoeff, fos, this.listener);

        //DCTSteganography stego = new DCTStegoCERep();
        //stego.extract(deZigZagCoeff, fos, this.listener);

        this.steganograph.extract(deZigZagCoeff, fos, this.listener);

        // stego ends }}}
    }

}
