package james;

import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import info.guardianproject.f5android.Extract;

/**
 * Created by askar on 22.4.2016.
 */
public class DCTStegoLSB implements DCTSteganography{
    private final int maxLengthBits = 16;

    public boolean loadKeyFromString (final String s) {
        // intentionally left blank
        return true;
    }

    public String generateStegoKeyString () {
        return "autobus";
    }

    public int setCoeffToBit (final int coeff, final int bit) {
        if (coeff >= 0) {
            if (coeff % 2 != bit) {
                return coeff + 1;
            }
            else {
                return coeff;
            }
        }
        else {
            if ((-coeff) % 2 != bit) {
                return coeff - 1;
            }
            else {
                return coeff;
            }
        }
    }

    public int getBitFromCoeff (final int coeff) {
        if (coeff >= 0) {
            return coeff % 2;
        }
        else {
            return (-coeff) % 2;
        }
    }

    public void embed (int coeff[], final InputStream embeddedData) {
        Log.d(Jpeg.LOG, "embedding started");

        int bytesToEmbed = -1;
        try {
            bytesToEmbed = embeddedData.available();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Log.d(Jpeg.LOG, "length of secret message is " + String.valueOf(bytesToEmbed));
        if (bytesToEmbed < 0 || bytesToEmbed >= (1 << maxLengthBits)) {
            Log.e(Jpeg.LOG, "Length error: negative or too big");
            return;
        }

        String origCoeffsPref = "";
        for (int i = 0; i < 100; i++) {
            origCoeffsPref += String.valueOf(coeff[i]) + ",\t";
        }
        Log.d(Jpeg.LOG, "orig coeff[]: " + origCoeffsPref);

        for (int i = 0; i < maxLengthBits; i++) {
            coeff[i] = this.setCoeffToBit(coeff[i], bytesToEmbed % (1 << (i+1)) / (1 << i));
        }

        for (int i = 0; i < bytesToEmbed; i++) {
            int secretByte = -1;
            try {
                secretByte = embeddedData.read();
            } catch (IOException e) {
                // @TODO correct error handling
                e.printStackTrace();
                break;
            }
            for (int j = 0; j < 8; j++) {
                int secretBit = secretByte % (1 << (j+1)) / (1 << j);
                int pos = maxLengthBits + 8*i + j;
                coeff[pos] = this.setCoeffToBit(coeff[pos], secretBit);
            }
        }

        String modiCoeffPref = "";
        for (int i = 0; i < 100; i++) {
            modiCoeffPref += String.valueOf(coeff[i]) + ",\t";
        }
        Log.d(Jpeg.LOG, "modi coeff[]: " + modiCoeffPref);
    }

    public void extract (int coeff[],  ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        Log.d(Jpeg.LOG, "extraction started");

        String origCoeffsPref = "";
        for (int i = 0; i < 100; i++) {
            origCoeffsPref += String.valueOf(coeff[i]) + ",\t";
        }
        Log.d(Jpeg.LOG, "enve coeff[]: " + origCoeffsPref);

        int[] lengthBits = new int[maxLengthBits];
        for (int i = 0; i < maxLengthBits; i++) {
            lengthBits[i] = this.getBitFromCoeff(coeff[i]);
        }
        int length = 0;
        for (int i = maxLengthBits - 1; i >= 0; i--) {
            // from least to most significant
            length = 2 * length + lengthBits[i];
        }

        Log.d(Jpeg.LOG, "length of embedded message is " + String.valueOf(length));

        for (int i = 0; i < length; i++) {
            int embeddedByte = 0;
            for (int j = 7; j >= 0; j--) {
                final int bit = this.getBitFromCoeff(coeff[maxLengthBits + 8*i + j]);
                embeddedByte = 2 * embeddedByte + bit;
            }
            fos.write(embeddedByte);
        }

        Log.d(Jpeg.LOG, "extraction finished.");

        listener.onExtractionResult(fos);
    }
}
