/*
 * Decompiled with CFR 0.152.
 */
package dataApp2GWTGuiMapper.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import dataApp2GWTGuiMapper.client.ValidateDataFromFormCallback;
import dataApp2GWTGuiMapper.data.FormData;
import dataApp2GWTGuiMapper.data.ValidationDataResult;
import dataApp2GWTGuiMapper.data.WidgetData;
import dataApp2GWTGuiMapper.metadata.FormMetadata;
import dataApp2GWTGuiMapper.metadata.WidgetMetadata;
import dataApp2GWTGuiMapper.services.client.performAction.PerformActionService;
import dataApp2GWTGuiMapper.services.client.performAction.PerformActionServiceAsync;
import dataApp2GWTGuiMapper.services.client.updateForm.UpdateFormService;
import dataApp2GWTGuiMapper.services.client.updateForm.UpdateFormServiceAsync;
import dataApp2GWTGuiMapper.services.client.updateObject.UpdateObjectService;
import dataApp2GWTGuiMapper.services.client.updateObject.UpdateObjectServiceAsync;
import dataApp2GWTGuiMapper.services.client.validateForm.ValidateFormService;
import dataApp2GWTGuiMapper.services.client.validateForm.ValidateFormServiceAsync;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGUIMapperClient {
    private ValidationDataResult[] validationResults;
    private String formId;
    private FormMetadata formMetaData;
    private RootPanel rootPanel;
    final AsyncCallback handleUpdateFormFromDataCallback = new AsyncCallback(){

        public void onSuccess(Object result) {
            if (result != null) {
                FormData theData = null;
                Set theResultSet = (Set)result;
                for (Object theObj : theResultSet) {
                    if (theObj instanceof FormData) {
                        theData = (FormData)theObj;
                        continue;
                    }
                    if (!(theObj instanceof FormMetadata)) continue;
                    DataGUIMapperClient.this.formMetaData = (FormMetadata)theObj;
                }
                for (WidgetData theWData : theData.getWidgetsData()) {
                    Widget theWidget = DataGUIMapperClient.this.getWidgetWithName(theWData.getName(), DataGUIMapperClient.this.rootPanel.iterator());
                    if (theWidget == null) continue;
                    if (theWidget instanceof TextBox) {
                        ((TextBox)theWidget).setText(theWData.getData());
                    }
                    if (theWidget instanceof ListBox) {
                        int i;
                        ListBox theLB = (ListBox)theWidget;
                        theLB.clear();
                        if (theWData.getMultidata() != null) {
                            i = 0;
                            while (i < theWData.getMultidata().length) {
                                theLB.addItem(theWData.getMultidata()[i], theWData.getMultidata()[i]);
                                ++i;
                            }
                        }
                        if (theWData.getData() != null) {
                            i = 0;
                            while (i < theLB.getItemCount()) {
                                String theSData = theLB.getValue(i);
                                if (theSData.equals(theWData.getData())) {
                                    theLB.setSelectedIndex(i);
                                }
                                ++i;
                            }
                        }
                    }
                    if (!(theWidget instanceof Label)) continue;
                    ((Label)theWidget).setText(theWData.getData());
                }
            }
        }

        public void onFailure(Throwable caught) {
            System.out.println(caught);
        }
    };
    final AsyncCallback handleUpdateDataFromFormCallback = new AsyncCallback(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            System.out.println(caught);
        }
    };
    final AsyncCallback peformActionCallback = new AsyncCallback(){

        public void onFailure(Throwable caught) {
            System.out.println(caught);
        }

        public void onSuccess(Object result) {
        }
    };

    public DataGUIMapperClient(RootPanel aRootPanel) {
        this.rootPanel = aRootPanel;
        this.formId = this.getFormId();
    }

    public FormMetadata getFormMetaData() {
        return this.formMetaData;
    }

    public RootPanel getRootPanel() {
        return this.rootPanel;
    }

    public void handleUpdateFormFromData() {
        DataGUIMapperClient.getUpdateFormService().getFormAndMetaData(this.formId, this.handleUpdateFormFromDataCallback);
    }

    public void handleUpdateDataFromForm() {
        Iterator<WidgetMetadata> theFmetaDataIter = this.formMetaData.getWidgets().iterator();
        FormData ret = new FormData();
        ret.setFormId(this.formId);
        while (theFmetaDataIter.hasNext()) {
            WidgetMetadata theWMData = theFmetaDataIter.next();
            WidgetData theWData = new WidgetData();
            theWData.setName(theWMData.getName());
            Widget theWidget = this.getWidgetWithName(theWMData.getName(), this.rootPanel.iterator());
            if (theWidget == null) continue;
            if (theWidget instanceof TextBox) {
                theWData.setData(((TextBox)theWidget).getText());
                ret.addWidgetData(theWData);
            }
            if (!(theWidget instanceof ListBox)) continue;
            ListBox theLB = (ListBox)theWidget;
            theWData.setData(theLB.getValue(theLB.getSelectedIndex()));
        }
        DataGUIMapperClient.getUpdateObjectService().updateData(ret, this.handleUpdateDataFromFormCallback);
    }

    public void validateDataFromForm(ValidateDataFromFormCallback aCallBack) {
        Iterator<WidgetMetadata> theFmetaDataIter = this.formMetaData.getWidgets().iterator();
        FormData ret = new FormData();
        ret.setFormId(this.formId);
        while (theFmetaDataIter.hasNext()) {
            WidgetMetadata theWMData = theFmetaDataIter.next();
            WidgetData theWData = new WidgetData();
            theWData.setName(theWMData.getName());
            Widget theWidget = this.getWidgetWithName(theWMData.getName(), this.rootPanel.iterator());
            if (theWidget == null) continue;
            if (theWidget instanceof TextBox) {
                theWData.setData(((TextBox)theWidget).getText());
                ret.addWidgetData(theWData);
            }
            if (!(theWidget instanceof ListBox)) continue;
            ListBox theLB = (ListBox)theWidget;
            theWData.setData(theLB.getValue(theLB.getSelectedIndex()));
        }
        DataGUIMapperClient.getValidateFormService().validateData(ret, aCallBack);
    }

    public void performAction(String anActionId) {
        DataGUIMapperClient.getPerformActionService().performAction(anActionId, this.peformActionCallback);
    }

    protected Widget getWidgetWithName(String aName, Iterator<Widget> aWIter) {
        Widget ret = null;
        while (aWIter.hasNext()) {
            Widget theWidget = aWIter.next();
            if (theWidget.getStyleName().equals(aName)) {
                ret = theWidget;
                break;
            }
            if (!(theWidget instanceof Panel)) continue;
            ret = this.getWidgetWithName(aName, ((Panel)theWidget).iterator());
        }
        return ret;
    }

    public static UpdateFormServiceAsync getUpdateFormService() {
        UpdateFormServiceAsync service = (UpdateFormServiceAsync)GWT.create(UpdateFormService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        String moduleRelativeURL = String.valueOf(GWT.getModuleBaseURL()) + "updateform/updateformservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    public static UpdateObjectServiceAsync getUpdateObjectService() {
        UpdateObjectServiceAsync service = (UpdateObjectServiceAsync)GWT.create(UpdateObjectService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        String moduleRelativeURL = String.valueOf(GWT.getModuleBaseURL()) + "updateobject/updateobjectservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    public static ValidateFormServiceAsync getValidateFormService() {
        ValidateFormServiceAsync service = (ValidateFormServiceAsync)GWT.create(ValidateFormService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        String moduleRelativeURL = String.valueOf(GWT.getModuleBaseURL()) + "validateform/validateformservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    public static PerformActionServiceAsync getPerformActionService() {
        PerformActionServiceAsync service = (PerformActionServiceAsync)GWT.create(PerformActionService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        String moduleRelativeURL = String.valueOf(GWT.getModuleBaseURL()) + "performaction/performactionservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    private String getFormId() {
        if (this.getRootPanel() != null) {
            for (Widget theWidget : this.getRootPanel()) {
                if (!(theWidget instanceof FormPanel)) continue;
                FormPanel theForm = (FormPanel)theWidget;
                System.out.println(theForm.getElement().getId());
                return theForm.getElement().getId();
            }
        }
        return "";
    }

    protected void addValidationResults(ValidationDataResult[] aValue) {
        int i = 0;
        while (i < aValue.length) {
            int idx = this.whereToAddValidationResult(aValue[i]);
            if (idx > -1) {
                this.validationResults[idx] = aValue[i];
            } else if (this.validationResults == null) {
                this.validationResults = new ValidationDataResult[]{aValue[i]};
            } else {
                ValidationDataResult[] theTmpArr = this.validationResults;
                this.validationResults = new ValidationDataResult[this.validationResults.length + 1];
                System.arraycopy(theTmpArr, 0, this.validationResults, 0, theTmpArr.length);
                this.validationResults[this.validationResults.length - 1] = aValue[i];
            }
            ++i;
        }
    }

    protected int whereToAddValidationResult(ValidationDataResult aResult) {
        if (this.validationResults != null) {
            int i = 0;
            while (i < this.validationResults.length) {
                if (aResult.getWidgetName().equals(this.validationResults[i].getWidgetName()) && aResult.getValidationClassName().equals(this.validationResults[i].getValidationClassName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public ValidationDataResult[] getAllValidationData() {
        return this.validationResults;
    }

    public void clearValidationData() {
        this.validationResults = null;
    }

    public ValidationDataResult[] getValidationDataForWidget(String aWidgetName) {
        ValidationDataResult[] ret = null;
        if (this.validationResults != null) {
            int i = 0;
            while (i < this.validationResults.length) {
                if (this.validationResults[i].getWidgetName().equals(aWidgetName)) {
                    if (ret == null) {
                        ret = new ValidationDataResult[]{this.validationResults[i]};
                    } else {
                        ValidationDataResult[] theTmpArr = ret;
                        ret = new ValidationDataResult[theTmpArr.length + 1];
                        System.arraycopy(theTmpArr, 0, ret, 0, theTmpArr.length);
                        ret[ret.length - 1] = this.validationResults[i];
                    }
                }
                ++i;
            }
        }
        return ret;
    }
}

