package daggm.demo.client;

import java.util.HashMap;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

import dataApp2GWTGuiMapper.client.DataGUIMapperClient;
import dataApp2GWTGuiMapper.client.HandleUpdateDataFromFormCallback;
import dataApp2GWTGuiMapper.client.HandleUpdateFormFromDataCallback;
import dataApp2GWTGuiMapper.client.PerformActionCallback;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class DAGGMDemo implements EntryPoint {
	/**
	 * The message displayed to the user when the server cannot be reached or
	 * returns an error.
	 */
	private static final String SERVER_ERROR = "An error occurred while "
			+ "attempting to contact the server. Please check your network "
			+ "connection and try again.";

	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final GreetingServiceAsync greetingService = GWT
			.create(GreetingService.class);

	private FormPanel loginFormPanel;
	private TextBox loginTextBox;
	private PasswordTextBox passwordTextBox;
	private Button loginButton;
	private String loginFormPanelId = "LOGINFP" + System.currentTimeMillis();
	private DataGUIMapperClient loginFormMapper;
	
	private FormPanel registerFormPanel;
	private TextBox newLoginTB;
	private PasswordTextBox newPasswordTB;
	private Button registerButton;
	private Button closeRegisterDialog;
	private String registerFormPanelId = "REGISTERFP" + System.currentTimeMillis();
	private DialogBox registerBox;
	private DataGUIMapperClient registerFormMapper;
	private Label registerErrLabel;
	
	private Button openRegDialog;
	
	public void onModuleLoad() {
		greetingService.greetServer(new String[]{loginFormPanelId, registerFormPanelId}, new AsyncCallback<String>() {

			public void onFailure(Throwable caught) {
			}

			public void onSuccess(String result) {
				load();
			}
		});
	}
	
	public void load() {
		loginFormPanel = new FormPanel();
		loginFormPanel.setStyleName("loginPanel");
		loginFormPanel.getElement().setId(loginFormPanelId);
		VerticalPanel theVPanel = new VerticalPanel();
		loginFormPanel.add(theVPanel);
		
		HorizontalPanel theHPanel = new HorizontalPanel();
		Label theLabel = new Label("Login : ");
		loginTextBox = new TextBox();
		loginTextBox.setStyleName("LOGINFP_LTB");
		theHPanel.add(theLabel);
		theHPanel.add(loginTextBox);
		theVPanel.add(theHPanel);
		
		theHPanel = new HorizontalPanel();
		theLabel = new Label("Password : ");
		passwordTextBox = new PasswordTextBox();
		passwordTextBox.setStyleName("LOGINFP_PTB");
		theHPanel.add(theLabel);
		theHPanel.add(passwordTextBox);
		theVPanel.add(theHPanel);
		
		theHPanel = new HorizontalPanel();
		loginButton = new Button("Login");
		loginButton.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				loginFormMapper.handleUpdateDataFromForm(new LoginBtnCallBack());
			}
		});
		theHPanel.add(loginButton);
		
		openRegDialog = new Button("Register me");
		openRegDialog.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				registerBox.center();
			}
		});
		theHPanel.add(openRegDialog);
		
		theVPanel.add(theHPanel);
		
		RootPanel.get("loginForm").add(loginFormPanel);
		loginFormMapper = new DataGUIMapperClient(loginFormPanel, loginFormPanelId);
		
		// Create the popup dialog box
		registerBox = new DialogBox();
		registerBox.setText("New user register");
		registerBox.setAnimationEnabled(true);
		closeRegisterDialog = new Button("Close");
		// We can set the id of a widget by accessing its Element
		registerFormPanel = new FormPanel();
		registerFormPanel.getElement().setId(registerFormPanelId);
		registerFormPanel.setStyleName("registerPanel");
		theVPanel = new VerticalPanel();
		registerFormPanel.add(theVPanel);
		
		registerErrLabel = new Label();
		theVPanel.add(registerErrLabel);
		
		theHPanel = new HorizontalPanel();
		theLabel = new Label("Login : ");
		newLoginTB = new TextBox();
		newLoginTB.setStyleName("REGFP_LTB");
		newLoginTB.addChangeHandler(new ChangeHandler() {
			
			public void onChange(ChangeEvent event) {
				registerFormMapper.handleUpdateDataFromForm(new HandleUpdateDataFromFormCallback());
				HashMap<String, String> aParams = new HashMap<String, String>();
				aParams.put("formId", registerFormPanelId);
				registerFormMapper.performAction("ValidateLogin", aParams, new ValidateLoginCallback());
			}
		});
		theHPanel.add(theLabel);
		theHPanel.add(newLoginTB);
		theVPanel.add(theHPanel);
		
		theHPanel = new HorizontalPanel();
		theLabel = new Label("Password : ");
		newPasswordTB = new PasswordTextBox();
		newPasswordTB.setStyleName("REGFP_PTB");
		theHPanel.add(theLabel);
		theHPanel.add(newPasswordTB);
		theVPanel.add(theHPanel);
		
		theHPanel = new HorizontalPanel();
		registerButton = new Button("Register");
		registerButton.setEnabled(false);
		registerButton.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				registerFormMapper.handleUpdateDataFromForm(new HandleUpdateDataFromFormCallback());
				HashMap<String, String> aParams = new HashMap<String, String>();
				aParams.put("formId", registerFormPanelId);
				registerFormMapper.performAction("RegisterUser", aParams, new PerformActionCallback());
				newPasswordTB.setText(null);
				newLoginTB.setText(null);
				registerFormMapper.handleUpdateDataFromForm(new HandleUpdateDataFromFormCallback());
				registerBox.hide();
			}
		});
		theHPanel.add(registerButton);
		
		closeRegisterDialog = new Button("Close");
		closeRegisterDialog.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent event) {
				registerBox.hide();
			}
		});
		theHPanel.add(closeRegisterDialog);
		theVPanel.add(theHPanel);
		
		registerBox.add(registerFormPanel);
		registerFormMapper = new DataGUIMapperClient(registerBox, registerFormPanelId);
		
		loginFormMapper.handleUpdateFormFromData(new HandleUpdateFormFromDataCallback(loginFormMapper));
		registerFormMapper.handleUpdateFormFromData(new HandleUpdateFormFromDataCallback(registerFormMapper));
	}
	
	// --------
	
	public class LoginCallback extends PerformActionCallback {
		
		public void onSuccess(Object result) {
			super.onSuccess(result);
			if (result != null && result instanceof HashMap) {
				HashMap res = (HashMap) result;
				String aLoginName = (String)res.get("login");
				if (aLoginName != null && !aLoginName.equals("null") && aLoginName.length() > 0) {
					RootPanel.get("loggedUsr").clear();
					RootPanel.get("loggedUsr").add(new Label("Currently logged user : " + aLoginName));
				} else {
					RootPanel.get("loggedUsr").clear();
					RootPanel.get("loggedUsr").add(new Label("Unable to log you in"));
				}
			}
		}
		
	}
	
	// ------------
	
	public class LoginBtnCallBack extends HandleUpdateDataFromFormCallback {
		
		public void onSuccess(Object result) {
			super.onSuccess(result);
			HashMap<String, String> aParams = new HashMap<String, String>();
			aParams.put("formId", loginFormPanelId);
			loginFormMapper.performAction("LoginUser", aParams, new LoginCallback());
		}
		
	}

	// ------------
	
	public class ValidateLoginCallback extends PerformActionCallback {
		
		public void onSuccess(Object result) {
			super.onSuccess(result);
			if (result != null && result instanceof HashMap) {
				HashMap res = (HashMap) result;
				String aLoginName = (String)res.get("login");
				if (aLoginName == null || aLoginName.equals("Process")) {
					registerButton.setEnabled(true);
					registerErrLabel.setText("");
				} else {
					registerButton.setEnabled(false);
					registerErrLabel.setText("Wrong login name");
				}
			}
		}
		
	}
	
}
