/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package dataApp2GWTGuiMapper.client;

import java.util.HashMap;
import java.util.Iterator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

import dataApp2GWTGuiMapper.data.FormData;
import dataApp2GWTGuiMapper.data.ValidationDataResult;
import dataApp2GWTGuiMapper.data.WidgetData;
import dataApp2GWTGuiMapper.metadata.FormMetadata;
import dataApp2GWTGuiMapper.metadata.WidgetMetadata;
import dataApp2GWTGuiMapper.services.client.performAction.PerformActionService;
import dataApp2GWTGuiMapper.services.client.performAction.PerformActionServiceAsync;
import dataApp2GWTGuiMapper.services.client.updateForm.UpdateFormService;
import dataApp2GWTGuiMapper.services.client.updateForm.UpdateFormServiceAsync;
import dataApp2GWTGuiMapper.services.client.updateObject.UpdateObjectService;
import dataApp2GWTGuiMapper.services.client.updateObject.UpdateObjectServiceAsync;
import dataApp2GWTGuiMapper.services.client.validateForm.ValidateFormService;
import dataApp2GWTGuiMapper.services.client.validateForm.ValidateFormServiceAsync;

/**
 *
 * @author mildo
 */
public class DataGUIMapperClient {

    public DataGUIMapperClient(Panel aPanel) {
        rootPanel = aPanel;
        formId = getFormId();
    }
    
    public DataGUIMapperClient(Panel aPanel, String aFormId) {
        rootPanel = aPanel;
        formId = aFormId;
    }

    private ValidationDataResult[] validationResults;
    
    private String formId;

    private FormMetadata formMetaData;

    public FormMetadata getFormMetaData() {
        return formMetaData;
    }
    
    public void setFormMetaData(FormMetadata aValue) {
    	formMetaData = aValue;
    }

    // ----------

    private Panel rootPanel;

    public Panel getRootPanel() {
        return rootPanel;
    }

    // -------------

    public void handleUpdateFormFromData(HandleUpdateFormFromDataCallback aCallback) {
        getUpdateFormService().getFormAndMetaData(formId, aCallback);
    }

    public void handleUpdateDataFromForm(HandleUpdateDataFromFormCallback aCallback) {
        Iterator<WidgetMetadata> theFmetaDataIter = formMetaData.getWidgets().iterator();
        FormData ret = new FormData();
        ret.setFormId(formId);
        while (theFmetaDataIter.hasNext()) {
            WidgetMetadata theWMData = theFmetaDataIter.next();
            WidgetData theWData = new WidgetData();
            theWData.setName(theWMData.getName());
            Widget theWidget = getWidgetWithName(theWMData.getName(), rootPanel.iterator());
            if (theWidget != null) {
                if (theWidget instanceof TextBox) {
                    theWData.setData(((TextBox)theWidget).getText());
                    ret.addWidgetData(theWData);
                }
                if (theWidget instanceof PasswordTextBox) {
                    theWData.setData(((PasswordTextBox)theWidget).getText());
                    ret.addWidgetData(theWData);
                }
                if (theWidget instanceof ListBox) {
                	ListBox theLB = (ListBox) theWidget;
                	theWData.setData(theLB.getValue(theLB.getSelectedIndex()));
                }
            }
        }
        getUpdateObjectService().updateData(ret, aCallback);
    }

    // -----------
    
    public void validateDataFromForm(ValidateDataFromFormCallback aCallBack) {
        Iterator<WidgetMetadata> theFmetaDataIter = formMetaData.getWidgets().iterator();
        FormData ret = new FormData();
        ret.setFormId(formId);
        while (theFmetaDataIter.hasNext()) {
            WidgetMetadata theWMData = theFmetaDataIter.next();
            WidgetData theWData = new WidgetData();
            theWData.setName(theWMData.getName());
            Widget theWidget = getWidgetWithName(theWMData.getName(), rootPanel.iterator());
            if (theWidget != null) {
                if (theWidget instanceof TextBox) {
                    theWData.setData(((TextBox)theWidget).getText());
                    ret.addWidgetData(theWData);
                }
                if (theWidget instanceof PasswordTextBox) {
                    theWData.setData(((PasswordTextBox)theWidget).getText());
                    ret.addWidgetData(theWData);
                }
                if (theWidget instanceof ListBox) {
                	ListBox theLB = (ListBox) theWidget;
                	theWData.setData(theLB.getValue(theLB.getSelectedIndex()));
                }
            }
        }
        getValidateFormService().validateData(ret, aCallBack);
    }
    
    // -----------
    
    public void performAction(String anActionId, HashMap<String, String> aParams, PerformActionCallback aCallback) {
    	getPerformActionService().performAction(anActionId, aParams, aCallback);
    }
    
    // -----------
    
    protected Widget getWidgetWithName(String aName, Iterator<Widget> aWIter) {
        Widget ret = null;
        while (aWIter.hasNext()) {
            Widget theWidget = aWIter.next();
            if (theWidget.getStyleName().equals(aName)) {
                ret = theWidget;
                break;
            } else if (theWidget instanceof Panel){
                ret = getWidgetWithName(aName, ((Panel)theWidget).iterator());
                if (ret != null) {
                	break;
                }
            }
        }
        return ret;
    }

    public static UpdateFormServiceAsync getUpdateFormService(){
        // Create the client proxy. Note that although you are creating the
        // service interface proper, you cast the result to the asynchronous
        // version of
        // the interface. The cast is always safe because the generated proxy
        // implements the asynchronous interface automatically.
        UpdateFormServiceAsync service = (UpdateFormServiceAsync) GWT.create(UpdateFormService.class);
        // Specify the URL at which our service implementation is running.
        // Note that the target URL must reside on the same domain and port from
        // which the host page was served.
        //
        ServiceDefTarget endpoint = (ServiceDefTarget) service;
        String moduleRelativeURL = GWT.getModuleBaseURL() + "updateform/updateformservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    public static UpdateObjectServiceAsync getUpdateObjectService(){
        // Create the client proxy. Note that although you are creating the
        // service interface proper, you cast the result to the asynchronous
        // version of
        // the interface. The cast is always safe because the generated proxy
        // implements the asynchronous interface automatically.
        UpdateObjectServiceAsync service = (UpdateObjectServiceAsync) GWT.create(UpdateObjectService.class);
        // Specify the URL at which our service implementation is running.
        // Note that the target URL must reside on the same domain and port from
        // which the host page was served.
        //
        ServiceDefTarget endpoint = (ServiceDefTarget) service;
        String moduleRelativeURL = GWT.getModuleBaseURL() + "updateobject/updateobjectservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }
    
    public static ValidateFormServiceAsync getValidateFormService(){
        // Create the client proxy. Note that although you are creating the
        // service interface proper, you cast the result to the asynchronous
        // version of
        // the interface. The cast is always safe because the generated proxy
        // implements the asynchronous interface automatically.
    	ValidateFormServiceAsync service = (ValidateFormServiceAsync) GWT.create(ValidateFormService.class);
        // Specify the URL at which our service implementation is running.
        // Note that the target URL must reside on the same domain and port from
        // which the host page was served.
        //
        ServiceDefTarget endpoint = (ServiceDefTarget) service;
        String moduleRelativeURL = GWT.getModuleBaseURL() + "validateform/validateformservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }
    
    public static PerformActionServiceAsync getPerformActionService(){
        // Create the client proxy. Note that although you are creating the
        // service interface proper, you cast the result to the asynchronous
        // version of
        // the interface. The cast is always safe because the generated proxy
        // implements the asynchronous interface automatically.
    	PerformActionServiceAsync service = (PerformActionServiceAsync) GWT.create(PerformActionService.class);
        // Specify the URL at which our service implementation is running.
        // Note that the target URL must reside on the same domain and port from
        // which the host page was served.
        //
        ServiceDefTarget endpoint = (ServiceDefTarget) service;
        String moduleRelativeURL = GWT.getModuleBaseURL() + "performaction/performactionservice";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
        return service;
    }

    private String getFormId() {
    	if (getRootPanel() != null) {
    		Iterator<Widget> theIter = getRootPanel().iterator();
    		while (theIter.hasNext()) {
    			Widget theWidget = theIter.next();
    			if (theWidget instanceof FormPanel) {
    				FormPanel theForm = (FormPanel) theWidget;
    				System.out.println(theForm.getElement().getId());
    				return theForm.getElement().getId();
    			}
     		}
    	}
        return "";
    }
    
    // ---------
    
    /**
     * Adds validation result to array
     * @param aValue
     */
    protected void addValidationResults(ValidationDataResult[] aValue) {
    	for (int i = 0; i < aValue.length; i++) {
    		int idx = whereToAddValidationResult(aValue[i]);
    		if (idx > -1) {
    			validationResults[idx] = aValue[i];
    		} else if (validationResults == null) {
    			validationResults = new ValidationDataResult[]{aValue[i]};
    		} else {
    			ValidationDataResult[] theTmpArr = validationResults;
    			validationResults = new ValidationDataResult[validationResults.length + 1];
    			System.arraycopy(theTmpArr, 0, validationResults, 0, theTmpArr.length);
    			validationResults[validationResults.length - 1] = aValue[i];
    		}
    	}
    }
    
    /**
     * Returns index of where to replace old validation data or -1 if needed to be added to array.
     * @param aResult
     * @return
     */
    protected int whereToAddValidationResult(ValidationDataResult aResult) {
    	if (validationResults != null) {
	    	for (int i = 0; i < validationResults.length; i++) {
	    		if (aResult.getWidgetName().equals(validationResults[i].getWidgetName()) 
	    				&& aResult.getValidationClassName().equals(validationResults[i].getValidationClassName())) {
	    			return i;
	    		}
	    	}
    	}	
    	return -1;
    }
    
    /**
     * Return all validation data
     * @return
     */
    public ValidationDataResult[] getAllValidationData() {
    	return validationResults;
    }
    
    /**
     * Clears all validationData
     */
    public void clearValidationData() {
    	validationResults = null;
    }
    
    /**
     * Returns all validation data for given widget name
     * @param aWidgetName
     * @return
     */
    public ValidationDataResult[] getValidationDataForWidget(String aWidgetName) {
    	ValidationDataResult[] ret = null;
    	if (validationResults != null) {
    		for (int i = 0; i < validationResults.length; i++) {
    			if (validationResults[i].getWidgetName().equals(aWidgetName)) {
    				if (ret == null) {
    					ret = new ValidationDataResult[]{validationResults[i]};
    				} else {
    					ValidationDataResult[] theTmpArr = ret;
    	    			ret = new ValidationDataResult[theTmpArr.length + 1];
    	    			System.arraycopy(theTmpArr, 0, ret, 0, theTmpArr.length);
    	    			ret[ret.length - 1] = validationResults[i];
    				}
    			}
    		}
    	}
    	return ret;
    }

}
