package dataApp2GWTGuiMapper.client;

import java.util.Iterator;
import java.util.Set;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

import dataApp2GWTGuiMapper.data.FormData;
import dataApp2GWTGuiMapper.data.WidgetData;
import dataApp2GWTGuiMapper.metadata.FormMetadata;

@SuppressWarnings("unchecked")
public class HandleUpdateFormFromDataCallback implements AsyncCallback {

	public HandleUpdateFormFromDataCallback(DataGUIMapperClient aDataMapper) {
		dataGUIMapperClient = aDataMapper;
	}
	
	private DataGUIMapperClient dataGUIMapperClient;
	
	public DataGUIMapperClient dataMapper() {
		return dataGUIMapperClient;
	}
	
	public void onFailure(Throwable caught) {
		System.out.println(caught);
	}

	public void onSuccess(Object result) {
		if (result != null) {
            FormData theData = null;
            Set theResultSet = (Set) result;
            Iterator theIter = theResultSet.iterator();
            while (theIter.hasNext()) {
                Object theObj = theIter.next();
                if (theObj instanceof FormData) {
                    theData = (FormData) theObj;
                } else if (theObj instanceof FormMetadata) {
                    dataMapper().setFormMetaData((FormMetadata) theObj);
                }
            }
            Iterator<WidgetData> theWDataIter = theData.getWidgetsData().iterator();
            while (theWDataIter.hasNext()) {
                WidgetData theWData = theWDataIter.next();
                Widget theWidget = dataMapper().getWidgetWithName(theWData.getName(), dataMapper().getRootPanel().iterator());
                if (theWidget != null) {
                    if (theWidget instanceof TextBox) {
                    	if (theWData.getData() != null) {
                    		((TextBox) theWidget).setText(theWData.getData());
                    	}	
                    }
                    if (theWidget instanceof ListBox) {
                    	ListBox theLB = (ListBox) theWidget;
                    	theLB.clear();
                    	if (theWData.getMultidata() != null) {
                    		for (int i = 0; i < theWData.getMultidata().length; i++) {
                    			theLB.addItem(theWData.getMultidata()[i], theWData.getMultidata()[i]);
                    		}
                    	}
                    	if (theWData.getData() != null) {
                    		for (int i = 0; i < theLB.getItemCount(); i++) {
                    			String theSData = theLB.getValue(i);
                    			if (theSData.equals(theWData.getData())) {
                    				theLB.setSelectedIndex(i);
                    			}
                    		}
                    	}
                    }
                    if (theWidget instanceof Label) {
                    	if (theWData.getData() != null) {
                    		((Label) theWidget).setText(theWData.getData());
                    	}	
                    }
                    if (theWidget instanceof PasswordTextBox) {
                    	if (theWData.getData() != null) {
                    		((PasswordTextBox) theWidget).setText(theWData.getData());
                    	}
                    }
                }
            }
        }
	}

}
