/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package dataApp2GWTGuiMapper.metadataAnnotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import dataApp2GWTGuiMapper.metadata.FormMetadata;
import dataApp2GWTGuiMapper.metadata.IMetadataHelper;
import dataApp2GWTGuiMapper.metadata.IRegister;
import dataApp2GWTGuiMapper.metadata.ValidationMetadata;
import dataApp2GWTGuiMapper.metadata.WidgetMetadata;
import dataApp2GWTGuiMapper.validation.MaxLengthValidation;
import dataApp2GWTGuiMapper.validation.MinLengthValidation;

/**
 *
 * @author mildo
 */
public class MetaDataHelper
    implements IMetadataHelper
{

    private HashMap<String, FormMetadata> formMap;

    @SuppressWarnings("unchecked")
	public void buildFormsMetadata(IRegister aBuildFrom) {
        formMap = new HashMap<String, FormMetadata>();
        Iterator<Class> theClassIterator = aBuildFrom.getRegistredObjects().iterator();
        while (theClassIterator.hasNext()) {
            Class theClass = theClassIterator.next();
            Method[] theMethods = theClass.getMethods();
            for (Method theMethod : theMethods) { 
                Annotation[] theAnnotations = theMethod.getAnnotations();
                HashSet<ValidationMetadata> theValidations = new HashSet<ValidationMetadata>();
                for (Annotation theAnnot : theAnnotations) {
                	if (theAnnot.annotationType().isAnnotationPresent(Validation.class)) {
                		ValidationMetadata theVMData = buildValidationMetadata(theAnnot);
                		if (theVMData != null) {
                			theValidations.add(theVMData);
                		}	
                	}
                }
                for (Annotation theAnnot : theAnnotations) {
	                if (theAnnot instanceof Form) {
	                    processFormAnnotation((Form)theAnnot, theClass, theMethod, theValidations);
	                }
	                if (theAnnot instanceof Forms) {
	                    for (Form theFormAnnot : ((Forms)theAnnot).forms()) {
	                        processFormAnnotation(theFormAnnot, theClass, theMethod, theValidations);
	                    }
	                }
                } 
            }
        }
    }

    protected ValidationMetadata buildValidationMetadata(Annotation aValidAnot) {
    	ValidationMetadata ret = null;
    	if (aValidAnot instanceof MaxLength) {
    		ret = new ValidationMetadata();
    		ret.setValidationClassName(MaxLengthValidation.class.getCanonicalName());
    		ret.setValidationKeys(new String[]{MaxLengthValidation.VALUE});
    		String theValue = String.valueOf(((MaxLength)aValidAnot).value());
    		ret.setValidationValues(new String[]{theValue});
    	}
    	if (aValidAnot instanceof MinLength) {
    		ret = new ValidationMetadata();
    		ret.setValidationClassName(MinLengthValidation.class.getCanonicalName());
    		ret.setValidationKeys(new String[]{MinLengthValidation.VALUE});
    		String theValue = String.valueOf(((MinLength)aValidAnot).value());
    		ret.setValidationValues(new String[]{theValue});
    	}
    	return ret;
    }
    
    protected void processFormAnnotation(Form aFormAnot, Class aClass, Method aMethod, Set<ValidationMetadata> aVMetadataList) {
        String theFormName = aFormAnot.name();
        FormMetadata theFMetadata = null;
        if (formMap.containsKey(theFormName)) {
            theFMetadata = formMap.get(theFormName);
        } else {
            theFMetadata = new FormMetadata();
            formMap.put(theFormName, theFMetadata);
        }
        Widget theWidgetAnot = aFormAnot.widget();
        WidgetMetadata theWMetadata = new WidgetMetadata();
        theWMetadata.setName(theWidgetAnot.name());
        theWMetadata.setBindingClass(aClass.getName());
        theWMetadata.setBindingMethod(aMethod.getName());
        theFMetadata.addWidget(theWMetadata);
        theFMetadata.setName(theFormName);
        theWMetadata.setValidationMetadata(aVMetadataList);
    }

    public FormMetadata getFormMetadata(String aName) {
        if (formMap != null) {
            return formMap.get(aName);
        }
        return null;
    }

}
