/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package dataApp2GWTGuiMapper.server;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import dataApp2GWTGuiMapper.data.FormData;
import dataApp2GWTGuiMapper.data.FormRepositoryItem;
import dataApp2GWTGuiMapper.data.FormsRepository;
import dataApp2GWTGuiMapper.data.WidgetData;
import dataApp2GWTGuiMapper.metadata.WidgetMetadata;
import dataApp2GWTGuiMapper.reflection.ReflectHelper;

/**
 *
 * @author mildo
 */
public class DataGUIMapperServer {

    public DataGUIMapperServer() {
    }

    // --------------

    public void handleUpdateFormFromObject(String aFormId) {
        FormRepositoryItem theItem = FormsRepository.getInstance().getItem4Id(aFormId);
        FormData theFData = new FormData();
        theFData.setFormId(aFormId);
        theItem.setFormData(theFData);
        if (theItem != null) {
            Set<WidgetMetadata> theWidgetMDatas = theItem.getMetadata().getWidgets();
            for (WidgetMetadata theMData : theWidgetMDatas) {
                try {
                    Object theDataObject = ReflectHelper.getInstanceOf(theItem.getDataObjects(), theMData.getBindingClass());
                    if (theDataObject != null) {
                        Object theData = ReflectHelper.getFieldValue(theDataObject, theMData.getBindingMethod());
                        WidgetData theWData = theItem.getFormData().getWidget(theMData.getName());
                        if (theWData == null) {
                        	theWData = new WidgetData();
                        }
                        try {
                        	if (theData != null) {
		                        String theValue = String.valueOf(theData);
		                        theWData.setData(theValue);
                        	} 
                        } catch (Exception ex) {
                        }
                        try {
                        	if (theData != null) { 
	                        	String[] theValue = (String[]) theData;
	                        	theWData.setMultiData(theValue);
                        	}	
                        } catch (Exception ex) {
        
                        }
                        theWData.setName(theMData.getName());
                        theFData.addWidgetData(theWData);
                    }
                } catch (ClassNotFoundException ex) {
                    Logger.getLogger(DataGUIMapperServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void handleUpdateObjectFromForm(String aFormId) {
        FormRepositoryItem theItem = FormsRepository.getInstance().getItem4Id(aFormId);
        FormData theFData = theItem.getFormData();
        theFData.setFormId(aFormId);
        if (theItem != null) {
            Set<WidgetMetadata> theWidgetMDatas = theItem.getMetadata().getWidgets();
            for (WidgetMetadata theMData : theWidgetMDatas) {
                try {
                    Object theDataObject = ReflectHelper.getInstanceOf(theItem.getDataObjects(), theMData.getBindingClass());
                    WidgetData theWData = theFData.getWidget(theMData.getName());
                    if (theDataObject != null && theWData != null) {
                        String aValue = theWData.getData();
                        boolean succes = ReflectHelper.setFieldValue(theDataObject, theMData.getBindingMethod(), aValue);
                        if (succes) {
                        	System.out.println("New value set succesfully");
                        	System.out.println("Binding method : " + theMData.getBindingMethod());
                        	System.out.println("New value : " + aValue);
                        	System.out.println("Set to data object : " + theDataObject.hashCode());
                        } else {
                        	System.out.println("New value not set");
                        	System.out.println("Binding method : " + theMData.getBindingMethod());
                        	System.out.println("New value : " + aValue);
                        }
                    }
                } catch (ClassNotFoundException ex) {
                    Logger.getLogger(DataGUIMapperServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

}
