package core;
/**
 * @author martin kravec
 *
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;


public class AppletGame extends Applet implements ActionListener {

	Panel frst, sec, trd, mid, cap;

	TextField[] fld;

	Label[] lbl;
	
	Label lblvy0, lblvy1;
	
	Button btt;
	
	List lst = new List(7,true);

	Dimension dim;
	
	String[] kocky = {"Kocka O", "Kocka I", "Kocka S",
			"Kocka Z", "Kocka L", "Kocka J", "Kocka T"};

	int bad = 0;
	
	static TextArea t1 = new TextArea("",50,45);

	/**
	 * Inicializuje applet
	 */
	public static void printArea(String s) {
		t1.append(s);
	}
	
	public void init() {
		
		Font f = new Font("monospaced", Font.PLAIN, 10);
		t1.setFont(f);
		setBackground(Color.black);
		dim = new Dimension(40, 23);
		fld = new TextField[8];
		lbl = new Label[8];

		fld[0] = new TextField();
		fld[0].setPreferredSize(dim);
		lbl[0] = new Label("Maximalna vyska= ");
		lbl[0].setForeground(Color.white);

		fld[1] = new TextField();
		fld[1].setPreferredSize(dim);
		lbl[1] = new Label("Priemerna vyska= ");
		lbl[1].setForeground(Color.white);

		fld[2] = new TextField();
		fld[2].setPreferredSize(dim);
		lbl[2] = new Label("Velka diera= ");
		lbl[2].setForeground(Color.white);

		fld[3] = new TextField();
		fld[3].setPreferredSize(dim);
		lbl[3] = new Label("Stredna diera= ");
		lbl[3].setForeground(Color.white);
		
		fld[4] = new TextField();
		fld[4].setPreferredSize(dim);
		lbl[4] = new Label("Mala diera= ");
		lbl[4].setForeground(Color.white);

		fld[5] = new TextField();
		fld[5].setPreferredSize(dim);
		lbl[5] = new Label("Hlbka hry= ");
		lbl[5].setForeground(Color.white);

		fld[6] = new TextField();
		fld[6].setPreferredSize(dim);
		lbl[6] = new Label("Vyska hracieho pola= ");
		lbl[6].setForeground(Color.white);

		fld[7] = new TextField();
		fld[7].setPreferredSize(dim);
		lbl[7] = new Label("Sirka hracieho pola= ");
		lbl[7].setForeground(Color.white);
		
		for(int i=0; i<7; i++) {
			lst.add(kocky[i]);
		}
		

		btt = new Button("SIMULACIA");
		btt.addActionListener(this);

		btt.setPreferredSize(new Dimension(300, 23));

		frst = new Panel(new GridLayout(8, 2));
		cap = new Panel(new GridLayout(0, 1));
		sec = new Panel(new GridLayout(0, 1));
		trd = new Panel(new GridLayout(0, 1));
		mid = new Panel(new GridLayout(0, 1));

		for (int i = 0; i < 8; i++) {
			frst.add(lbl[i]);
			frst.add(fld[i]);
		}

		lblvy0 = new Label("Vyber kociek pre simulaciu");
		lblvy0.setForeground(Color.white);
		
		lblvy1 = new Label(" ");
		lblvy1.setForeground(Color.red);

		cap.add(lblvy0);
		sec.add(lst);
		trd.add(btt);
		trd.add(lblvy1);
		mid.add(t1);

		setSize(310, 1000);
		add(frst);
		add(cap);
		add(sec);
		add(trd);
		add(mid);
	}

	public double parse(String s) {
		try {
			if (s.indexOf(",") == -1)
				return (new BigInteger(s)).doubleValue();
			else {
				String[] ss;
				ss = (s).split(",");
				//System.out.println(ss.length);
				return (new BigInteger(ss[0])).doubleValue()
						+ (new BigInteger(ss[1])).doubleValue()
						/ Math.exp(ss[1].length() * Math.log(10.0));
			}
		} catch (Exception e) {
			bad = 1;
		} finally {
		}
		return 0;

	}
	
	public int parseInt(String s) {
		try {
			return (new BigInteger(s)).intValue();
		} catch (Exception e) {
			bad = 1;
		} finally {
		}
		return 0;

	}

	public void actionPerformed(ActionEvent arg0) {
		bad = 0;
		
		int w = parseInt(fld[6].getText());
		int h = parseInt(fld[7].getText());

		String[] items = lst.getSelectedItems();
		int n = items.length;
		int f[] = new int[n];
		if(n==0) {
			bad=1;	
		} else {
			for(int i=0; i<7; i++) {
				for(int j=0; j<n; j++) {
					if(kocky[i].equals(items[j])) {
						f[j]=i;
					}
				}
			}
		}
		Game g = new Game(h,w,f);
		
		Game.p1 = parse(fld[0].getText()); 
		Game.p2 = parse(fld[1].getText()); 
		Game.p3 = parse(fld[2].getText()); 
		Game.p4 = parse(fld[3].getText()); 
		Game.p5 = parse(fld[4].getText()); 
		
		int hh = parseInt(fld[5].getText());
		if (bad == 1) {
			lblvy1.setText("ZLY VSTUP!!!");
		} else {
			g.run(hh);
			lblvy1.setText("SIMULACIA UKONCENA!!");			
		}
	}	
}

