package core;

public class Figure {
	
	private Position pos;
	
	private GridFigure grFig;
	
	public int type;
				
	private void createFigureTypeO() {
		grFig.setValue(0,0,true);
		grFig.setValue(-1,-1,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(-1,0,true);
		grFig.setHeight(-9999,1,1,-9999);
		grFig.setWidth(0,2,2,0);		
	}

	private void createFigureTypeI1() {
		grFig.setValue(-2,0,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(0,0,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(0,0,0,0);
		grFig.setWidth(0,0,4,0);		
	}

	private void createFigureTypeI2() {
		grFig.setValue(0,-2,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,0,true);
		grFig.setValue(0,1,true);
		grFig.setHeight(-9999,-9999,2,-9999);
		grFig.setWidth(1,1,1,1);		
	}

	private void createFigureTypeS1() {
		grFig.setValue(0,0,true);
		grFig.setValue(-1,-1,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,1,1,0);
		grFig.setWidth(0,2,2,0);
	}

	private void createFigureTypeS2() {
		grFig.setValue(0,0,true);
		grFig.setValue(1,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,-9999,0,1);
		grFig.setWidth(0,1,2,1);
	}

	private void createFigureTypeZ1() {
		grFig.setValue(-1,0,true);
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(1,-1,true);
		grFig.setHeight(-9999,0,1,1);
		grFig.setWidth(0,2,2,0);
	}

	private void createFigureTypeZ2() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(1,1,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,-9999,1,0);
		grFig.setWidth(0,1,2,1);
	}

	private void createFigureTypeL1() {
		grFig.setValue(0,0,true);
		grFig.setValue(-1,-1,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,1,0,0);
		grFig.setWidth(0,1,3,0);
	}

	private void createFigureTypeL2() {
		grFig.setValue(0,1,true);
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(1,-1,true);
		grFig.setHeight(-9999,-9999,1,1);
		grFig.setWidth(0,2,1,1);
	}

	private void createFigureTypeL3() {
		grFig.setValue(0,0,true);
		grFig.setValue(1,0,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(1,1,true);
		grFig.setHeight(-9999,0,0,0);
		grFig.setWidth(0,0,3,1);
	}

	private void createFigureTypeL4() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(-1,1,true);
		grFig.setHeight(-9999,-1,1,-9999);
		grFig.setWidth(0,1,1,2);
	}

	private void createFigureTypeJ1() {
		grFig.setValue(0,0,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(1,0,true);
		grFig.setValue(1,-1,true);
		grFig.setHeight(-9999,0,0,1);
		grFig.setWidth(0,1,3,0);
	}

	private void createFigureTypeJ2() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(1,1,true);
		grFig.setHeight(-9999,-9999,1,-1);
		grFig.setWidth(0,1,1,2);
	}

	private void createFigureTypeJ3() {
		grFig.setValue(1,0,true);
		grFig.setValue(0,0,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(-1,1,true);
		grFig.setHeight(-9999,0,0,0);
		grFig.setWidth(0,0,3,1);
	}

	private void createFigureTypeJ4() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(-1,-1,true);
		grFig.setHeight(-9999,1,1,-9999);
		grFig.setWidth(0,2,1,1);
	}

	private void createFigureTypeT1() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,0,1,0);
		grFig.setWidth(0,1,3,0);
	}

	private void createFigureTypeT2() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(1,0,true);
		grFig.setHeight(-9999,-9999,1,0);
		grFig.setWidth(0,1,2,1);
	}

	private void createFigureTypeT3() {
		grFig.setValue(1,0,true);
		grFig.setValue(0,0,true);
		grFig.setValue(-1,0,true);
		grFig.setValue(0,1,true);
		grFig.setHeight(-9999,0,0,0);
		grFig.setWidth(0,0,3,1);
	}

	private void createFigureTypeT4() {
		grFig.setValue(0,0,true);
		grFig.setValue(0,-1,true);
		grFig.setValue(0,1,true);
		grFig.setValue(-1,0,true);
		grFig.setHeight(-9999,0,1,-9999);
		grFig.setWidth(0,1,2,1);
	}

	public Figure(int type) {
		super();
		// TODO Auto-generated constructor stub

		grFig = new GridFigure();
		
		pos = new Position(0,0);
		
		this.type = type;
		// type -=3;
        
		
		switch (type) {
        case 0 :
        	createFigureTypeO();
        	break;
        case 1 :
        	createFigureTypeI1();
        	break;
        case 2 :
        	createFigureTypeI2();
        	break;
        case 3 :
        	createFigureTypeS1();
        	break;
        case 4 :
        	createFigureTypeS2();
        	break;
        case 5 :
        	createFigureTypeZ1();
        	break;
        case 6 :
        	createFigureTypeZ2();
        	break;
        case 7 :
        	createFigureTypeL1();
        	break;
        case 8 :
        	createFigureTypeL2();
        	break;
        case 9 :
        	createFigureTypeL3();
        	break;
        case 10 :
        	createFigureTypeL4();
        	break;
        case 11 :
        	createFigureTypeJ1();
        	break;
        case 12 :
        	createFigureTypeJ2();
        	break;
        case 13 :
        	createFigureTypeJ3();
        	break;
        case 14 :
        	createFigureTypeJ4();
        	break;
        case 15 :
        	createFigureTypeT1();
        	break;
        case 16 :
        	createFigureTypeT2();
        	break;
        case 17 :
        	createFigureTypeT3();
        	break;
        case 18 :
        	createFigureTypeT4();
        	break;
        }
    }
	
	public Position getPos() {
		return pos;
	}

	public void setPos(Position pos) {
		this.pos = pos;
	}

	public void setPos(int x, int y) {
		this.pos.setPos(x,y);
	}
	
	public boolean canHold(GridGame g, int x, int y) {
		boolean result = true;
		
		if((x<0) || (x>=g.getWidth()) || (y<0) || (y>=g.getHeight())) return false;
		
		for(int i=-2; i<2; i++)
			for(int j=-2; j<2; j++) 
				result = result && !(g.getValue(x+i,y+j) && grFig.getValue(i,j));
		
		return result;		
	}
	
	public boolean isFlying(GridGame g, int x, int y) {
		//return canHold(g,x,y) && canHold(g,x,y-1);
		return canHold(g,x,y-1);
	}
	
	public int moveDown(GridGame g, int x) {
		int v = 0;
		
		
		for(int i=-2; i<2; i++)
			v = Math.max(v, g.getHeightGame(x+i)+grFig.getHeight(i));
		
		return v;
	}

	public GridFigure getGrFig() {
		return grFig;
	}

	public void setGrFig(GridFigure grFig) {
		this.grFig = grFig;
	}

	public int getType() {
		return type;
	}
	
}
