/*
 * Decompiled with CFR 0.152.
 */
package s3games;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import s3games.ai.Heuristic;
import s3games.ai.Strategy;
import s3games.engine.Game;
import s3games.engine.GameSpecification;
import s3games.gui.ControllerWindow;
import s3games.gui.GameWindow;
import s3games.gui.RobotControlWindow;
import s3games.io.Config;
import s3games.io.GameLogger;
import s3games.player.CameraPlayer;
import s3games.player.MousePlayer;
import s3games.player.Player;
import s3games.robot.Camera;
import s3games.robot.Robot;
import s3games.util.Switch;
import s3games.util.SwitchListener;

public class Controller
implements SwitchListener,
Runnable {
    private ControllerWindow cw;
    private GameWindow gw;
    private GameLogger logger;
    private Config config;
    private Game game;
    private Switch gameRunning;
    private Camera camera;
    private Robot robot;
    private final Object notifier = new Object();
    private int currentGameID = 1;
    private int numberOfRuns;
    private GameSpecification gameSpecification;
    private Player.boardType boardType;
    private Player.playerType[] playerTypes;
    private String[] playerStrategies;
    private String[] strategyHeuristics;
    private String gameName;

    public Controller() {
        this.gameRunning = new Switch();
        this.gameRunning.addSwitchListener(this);
        this.gw = new GameWindow(this.gameRunning);
        this.cw = new ControllerWindow(this);
        this.cw.setVisible(true);
        this.logger = new GameLogger();
        this.config = new Config(this.logger);
        this.config.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchChanged(boolean newState) {
        if (!newState) {
            this.cw.gameFinished(this.game.state.winner, this.game.state.playerScores);
            if (this.camera != null) {
                this.camera.close();
                this.camera = null;
            }
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notify();
            }
        }
    }

    public String[] getGameNames() {
        return new String[]{"MasterMind", "Squares_v2", "Squares", "Connect4", "Puzzle8", "Skipping", "Reversi", "RiverCrossing", "Alquerque", "Mill", "Nim", "Frogs", "TicTacToe"};
    }

    public String[] getStrategiesForGame(String gameName) {
        return Strategy.availableStrategies(gameName);
    }

    public String[] getHeuristicsForGame(String strategyName) {
        return Heuristic.availableHeuristics(strategyName);
    }

    public String[] getLearnableStrategyTypesForGame(String gameName) {
        ArrayList<String> learnable = new ArrayList<String>();
        for (String s : this.getStrategiesForGame(gameName)) {
            if (!Strategy.learnable(s)) continue;
            learnable.add(s);
        }
        String[] result = new String[learnable.size()];
        return learnable.toArray(result);
    }

    public int getNumberOfPlayersForGame(String gameName) {
        return 2;
    }

    public void play(String gameName, Player.boardType boardType2, Player.playerType[] playerTypes, String[] playerStrategies, String[] strategyHeuristics, int numberOfRuns) {
        if (this.gameRunning.isOn()) {
            return;
        }
        this.gw.setVisible(true);
        this.gameSpecification = new GameSpecification(this.config, this.logger);
        try {
            this.gameSpecification.load(gameName);
        }
        catch (Exception e) {
            this.gw.showException(e);
        }
        this.numberOfRuns = numberOfRuns;
        this.boardType = boardType2;
        this.playerTypes = playerTypes;
        this.playerStrategies = playerStrategies;
        this.strategyHeuristics = strategyHeuristics;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.cw.getStatisticFileName());
        }
        catch (IOException ex) {
            this.gw.showException(ex);
            return;
        }
        while (this.numberOfRuns-- > 0 && this.gw.isVisible()) {
            Object p;
            this.cw.setNumberOfRunsToGo(this.numberOfRuns + 1);
            this.gameRunning.setValue(this.currentGameID++);
            this.gameRunning.on();
            if (this.boardType == Player.boardType.REALWORLD) {
                this.camera = new Camera(this.gameSpecification);
                boolean robotNeeded = false;
                for (int player = 0; player < this.playerTypes.length; ++player) {
                    if (this.playerTypes[player] != Player.playerType.COMPUTER) continue;
                    robotNeeded = true;
                }
                try {
                    if (robotNeeded) {
                        this.robot = new Robot("/dev/ttyUSB0", this.gameSpecification);
                    }
                }
                catch (Exception e) {
                    this.gw.showException(e);
                }
            }
            this.game = new Game(this.config, this.logger, this.gw, this.gameRunning, this.robot);
            ArrayList<Object> players = new ArrayList<Object>();
            for (int player = 0; player < this.gameSpecification.playerNames.length; ++player) {
                if (this.playerTypes[player] == Player.playerType.HUMAN) {
                    p = this.boardType == Player.boardType.REALWORLD ? new CameraPlayer(this.gameSpecification, this.camera) : new MousePlayer(this.gameSpecification, this.gw);
                } else {
                    Heuristic h = Heuristic.getHeuristic(this.strategyHeuristics[player], this.gameSpecification);
                    p = Strategy.getStrategy(this.playerStrategies[player], h).getPlayer(this.gameSpecification);
                }
                ((Player)p).setPlayerNumber(player + 1);
                ((Player)p).setMaximumNumberOfNodes(this.cw.getNumberOfNodesToExpand());
                ((Player)p).setMaxTime(this.cw.getRunningTime());
                players.add(p);
            }
            Player[] pls = new Player[players.size()];
            this.game.setGameAndPlayers(this.gameSpecification, players.toArray(pls));
            p = this.notifier;
            synchronized (p) {
                this.game.start();
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cw.setNumberOfRunsToGo(0);
            try {
                fw.append(Integer.toString(this.game.state.winner) + System.getProperty("line.separator"));
                fw.flush();
            }
            catch (IOException ex) {
                this.gw.showException(ex);
            }
        }
        try {
            fw.close();
        }
        catch (IOException ex) {
            this.gw.showException(ex);
        }
    }

    public int learn(String gameName, Player.boardType boardType2, Player.playerType[] playerTypes, String[] playerStrategies, String[] strategyHeuristics, String learnStrategyType, String strategyFileName, int numberOfRuns) {
        System.out.println(gameName);
        System.out.println((Object)boardType2);
        for (int i = 0; i < playerTypes.length; ++i) {
            System.out.print((Object)((Object)playerTypes[i]) + " ");
            System.out.print(playerStrategies[i] + " ");
            System.out.println(strategyHeuristics[i] + " ");
        }
        System.out.println(learnStrategyType + " " + strategyFileName + " " + numberOfRuns);
        this.gw.setVisible(true);
        return 0;
    }

    public void controlRobot() {
        try {
            this.robot = new Robot("/dev/ttyUSB0", null);
            RobotControlWindow robotControlWindow = new RobotControlWindow(this.robot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

