/*
 * Decompiled with CFR 0.152.
 */
package s3games.ai;

import s3games.ai.DistanceFromGoalHeuristic;
import s3games.ai.MoreStonesHeuristic;
import s3games.ai.Puzzle8Heuristic;
import s3games.ai.ZeroHeuristic;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;

public abstract class Heuristic {
    public abstract double heuristic(GameState var1, int var2);

    public static String[] availableHeuristics(String gameName) {
        return new String[]{"Zero", "MoreStones", "DistanceFromGoal", "Puzzle8Heuristic"};
    }

    public static Heuristic getHeuristic(String name, GameSpecification specs) {
        if (name.equals("Zero")) {
            return new ZeroHeuristic();
        }
        if (name.equals("MoreStones")) {
            return new MoreStonesHeuristic(specs);
        }
        if (name.equals("DistanceFromGoal")) {
            return new DistanceFromGoalHeuristic();
        }
        if (name.equals("Puzzle8Heuristic")) {
            return new Puzzle8Heuristic();
        }
        return null;
    }
}

