/*
 * Decompiled with CFR 0.152.
 */
package s3games.ai;

import java.util.Map;
import s3games.ai.Heuristic;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;

public class MoreStonesHeuristic
extends Heuristic {
    private GameSpecification specs;

    public MoreStonesHeuristic(GameSpecification specs) {
        this.specs = specs;
    }

    @Override
    public double heuristic(GameState gameState, int forPlayer) {
        int myStones = 0;
        int otherStones = 0;
        for (Map.Entry<String, String> loel : gameState.locationElements.entrySet()) {
            if (loel.getValue() == null || !this.specs.locations.get((Object)loel.getKey()).relevant) continue;
            int owner = gameState.elementOwners.get(loel.getValue());
            if (owner == forPlayer) {
                ++myStones;
                continue;
            }
            ++otherStones;
        }
        if (myStones > otherStones) {
            return myStones / (myStones + otherStones);
        }
        if (myStones < otherStones) {
            return -otherStones / (myStones + otherStones);
        }
        return 0.0;
    }
}

