/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine;

import java.util.ArrayList;
import java.util.HashSet;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.gui.GameWindow;
import s3games.io.Config;
import s3games.io.GameLogger;
import s3games.player.Player;
import s3games.robot.Robot;
import s3games.util.Switch;

public class Game
extends Thread {
    public GameState state;
    public GameSpecification gameSpecification;
    public GameWindow window;
    public Config config;
    public GameLogger logger;
    public Player[] players;
    private Robot robot;
    private Switch gameRuns;
    private int id;

    public Game(Config config, GameLogger logger, GameWindow window, Switch gameRuns, Robot robot) {
        this.config = config;
        this.logger = logger;
        this.window = window;
        this.gameRuns = gameRuns;
        this.robot = robot;
        this.id = gameRuns.getValue();
    }

    public void setGameAndPlayers(GameSpecification gameSpecification, Player[] players) {
        this.gameSpecification = gameSpecification;
        this.players = players;
    }

    @Override
    public void run() {
        try {
            this.state = new GameState(this.gameSpecification, this.robot);
            int numberOfPlayers = this.gameSpecification.playerNames.length;
            this.window.setGame(this, this.gameRuns);
            do {
                Move nextMove;
                this.window.setState(this.state);
                Player playerOnMove = this.players[this.state.currentPlayer - 1];
                ArrayList<Move> allowedMoves = this.state.allPossibleMoves();
                System.out.println("All possible moves:");
                System.out.println(allowedMoves);
                System.out.println("Different possible moves:");
                HashSet<Move> movesZ = new HashSet<Move>();
                movesZ.addAll(allowedMoves);
                System.out.println(movesZ);
                if (allowedMoves.isEmpty()) {
                    this.state.winner = 0;
                    this.state.touch();
                    break;
                }
                boolean approved = false;
                do {
                    nextMove = playerOnMove.move(this.state, allowedMoves);
                    if (this.gameRuns.isOff() || this.gameRuns.getValue() != this.id) {
                        this.state.winner = 0;
                        return;
                    }
                    System.out.println("Player moves: " + nextMove.toString());
                    approved = this.state.moveAllowed(nextMove);
                    if (approved || playerOnMove.isComputer()) continue;
                    this.window.showException(new Exception("You cannot make move " + nextMove + " according to rules. Try again."));
                } while (!approved && !playerOnMove.isComputer());
                if (!approved) {
                    this.window.showException(new Exception("Player performed illegal move " + nextMove));
                    this.state.winner = this.state.currentPlayer % numberOfPlayers + 1;
                    this.state.touch();
                    break;
                }
                if (this.robot != null && playerOnMove.isComputer()) {
                    this.robot.moveRobot(nextMove);
                }
                this.state.performMove(nextMove);
                for (int p = 0; p < numberOfPlayers; ++p) {
                    if (playerOnMove == this.players[p]) continue;
                    this.players[p].otherMoved(nextMove, this.state);
                }
            } while (this.state.winner == -1);
            this.window.setState(this.state);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.window.showException(e);
        }
        this.gameRuns.off();
    }
}

