/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine;

import java.util.ArrayList;
import s3games.engine.Element;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Location;
import s3games.engine.Move;
import s3games.engine.expr.Context;
import s3games.engine.expr.Expr;

public class GameRule {
    public String name;
    public Expr element;
    public Expr state;
    public Expr currentPlayer;
    public Expr from;
    public Expr to;
    public Expr condition;
    public ArrayList<Expr> scorePlayer;
    public ArrayList<Expr> scoreAmount;
    public Expr action;

    public GameRule(String name) {
        this.name = name;
        this.scorePlayer = new ArrayList();
        this.scoreAmount = new ArrayList();
        this.condition = Expr.booleanExpr(true);
    }

    public boolean matches(Move move, Context context) throws Exception {
        GameState st = context.getState();
        if (this.element.matches(move.element, context) && (this.state == null || this.state.matches(st.elementStates.get(move.element), context)) && (this.currentPlayer == null || this.currentPlayer.matches(st.currentPlayer, context)) && this.from.matches(move.from, context) && this.to.matches(move.to, context)) {
            return this.condition.eval(context).isTrue();
        }
        return false;
    }

    public ArrayList<Move> getMatchingMoves(Element el, GameSpecification specs, Context context) throws Exception {
        String tryFrom;
        GameState st = context.getState();
        ArrayList<Move> moves = new ArrayList<Move>();
        if (this.element.matches(el.name.fullName, context) && (this.state == null || this.state.matches(st.elementStates.get(el.name.fullName), context)) && (this.currentPlayer == null || this.currentPlayer.matches(st.currentPlayer, context)) && this.from.matches(tryFrom = st.elementLocations.get(el.name.fullName), context)) {
            for (Location tryTo : specs.locations.values()) {
                if (st.locationElements.get(tryTo.name.fullName) != null || !this.to.matches(tryTo.name.fullName, context) || !this.condition.eval(context).isTrue()) continue;
                moves.add(new Move(tryFrom, tryTo.name.fullName, el.name.fullName, specs));
            }
        }
        if (moves.size() > 0) {
            return moves;
        }
        return null;
    }

    public void addScores(Context context) throws Exception {
        GameState gs = context.getState();
        for (int i = 0; i < this.scorePlayer.size(); ++i) {
            int player = this.scorePlayer.get(i).eval(context).getInt();
            int amount = this.scoreAmount.get(i).eval(context).getInt();
            int n = player - 1;
            gs.playerScores[n] = gs.playerScores[n] + amount;
        }
    }

    public void performAction(Context context) throws Exception {
        if (this.action != null) {
            this.action.eval(context);
        }
    }
}

