/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import s3games.engine.Element;
import s3games.engine.GameRule;
import s3games.engine.GameScoring;
import s3games.engine.GameSpecification;
import s3games.engine.Move;
import s3games.engine.expr.Context;
import s3games.engine.expr.Expr;
import s3games.robot.Robot;

public class GameState {
    public Map<String, Integer> elementStates;
    public Map<String, String> elementLocations;
    public Map<String, String> locationElements;
    public Map<String, Integer> elementOwners;
    public int currentPlayer;
    public int winner;
    private int hash;
    private boolean modified;
    public Map<String, Integer> elementzIndexes;
    public int[] playerScores;
    private Context context;

    public GameState getCopy() {
        GameState s = new GameState();
        s.elementzIndexes = new TreeMap<String, Integer>(this.elementzIndexes);
        s.playerScores = new int[this.playerScores.length];
        System.arraycopy(this.playerScores, 0, s.playerScores, 0, this.playerScores.length);
        s.elementStates = new TreeMap<String, Integer>(this.elementStates);
        s.elementLocations = new TreeMap<String, String>(this.elementLocations);
        s.locationElements = new TreeMap<String, String>(this.locationElements);
        s.elementOwners = new TreeMap<String, Integer>(this.elementOwners);
        s.currentPlayer = this.currentPlayer;
        s.winner = this.winner;
        s.hash = this.hash;
        s.modified = this.modified;
        s.context = this.context;
        return s;
    }

    public String toString() {
        return this.hashString();
    }

    public int hashCode() {
        if (this.modified) {
            this.recomputeHash();
        }
        return this.hash;
    }

    private String hashString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> loel : this.locationElements.entrySet()) {
            if (!this.context.specs.locations.get((Object)loel.getKey()).relevant) continue;
            b.append(loel.getKey());
            b.append('*');
            String el = loel.getValue();
            if (el != null) {
                b.append(this.context.specs.elements.get((Object)el).type);
                b.append('*');
                b.append(this.elementStates.get(el));
                b.append('*');
                b.append(this.elementOwners.get(el));
                b.append('*');
                b.append(this.elementzIndexes.get(el));
            }
            b.append('*');
        }
        b.append(Integer.toString(this.currentPlayer));
        b.append('*');
        b.append(Integer.toString(this.winner));
        b.append('*');
        b.append(Arrays.toString(this.playerScores));
        return b.toString();
    }

    private void recomputeHash() {
        this.hash = this.hashString().hashCode();
    }

    public void touch() {
        this.modified = true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GameState)) {
            return false;
        }
        return this.equals((GameState)other);
    }

    public GameState() {
        this.init();
    }

    public GameState(GameSpecification specs, Robot robot) {
        this.init();
        for (Map.Entry<String, Element> element : specs.elements.entrySet()) {
            this.elementStates.put(element.getKey(), element.getValue().initialState);
            this.elementLocations.put(element.getKey(), element.getValue().initialLocation);
            this.locationElements.put(element.getValue().initialLocation, element.getKey());
            this.elementOwners.put(element.getKey(), element.getValue().initialOwner);
        }
        for (Map.Entry<String, Element> element : specs.elements.entrySet()) {
            this.elementzIndexes.put(element.getKey(), element.getValue().initialZindex);
        }
        this.playerScores = new int[specs.playerNames.length];
        for (int i = 0; i < this.playerScores.length; ++i) {
            this.playerScores[i] = specs.initialPlayerScore;
        }
        this.context = new Context(this, specs, robot);
    }

    private void init() {
        this.elementStates = new TreeMap<String, Integer>();
        this.elementLocations = new TreeMap<String, String>();
        this.locationElements = new TreeMap<String, String>();
        this.elementOwners = new TreeMap<String, Integer>();
        this.elementzIndexes = new TreeMap<String, Integer>();
        this.currentPlayer = 1;
        this.winner = -1;
        this.modified = true;
    }

    public boolean equals(GameState other) {
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        Iterator<Map.Entry<String, String>> otherLocationElements = other.locationElements.entrySet().iterator();
        if (this.currentPlayer != other.currentPlayer) {
            return false;
        }
        for (Map.Entry<String, String> loel : this.locationElements.entrySet()) {
            Map.Entry<String, String> otherloel = otherLocationElements.next();
            if (!this.context.specs.locations.get((Object)loel.getKey()).relevant) continue;
            String el = loel.getValue();
            String otherel = otherloel.getValue();
            if (el != null) {
                if (otherel == null) {
                    return false;
                }
                if (!this.context.specs.elements.get((Object)el).type.equals(this.context.specs.elements.get((Object)otherel).type)) {
                    return false;
                }
                if (!this.elementStates.get(el).equals(other.elementStates.get(otherel))) {
                    return false;
                }
                if (!this.elementOwners.get(el).equals(other.elementOwners.get(otherel))) {
                    return false;
                }
                if (this.elementzIndexes.get(el).equals(other.elementzIndexes.get(otherel))) continue;
                return false;
            }
            if (otherel == null) continue;
            return false;
        }
        return true;
    }

    public Move findMove(GameState newState) {
        Move move = null;
        for (Map.Entry<String, String> eLoc : this.elementLocations.entrySet()) {
            String element = eLoc.getKey();
            String location = eLoc.getValue();
            if (location.equals(newState.elementLocations.get(element))) continue;
            if (move != null) {
                return null;
            }
            move = new Move(location, newState.elementLocations.get(element), element, this.context.specs);
        }
        return move;
    }

    public ArrayList<Move> allPossibleMoves() throws Exception {
        ArrayList<Move> moves = new ArrayList<Move>();
        this.context.setState(this);
        for (GameRule rule : this.context.specs.rules.values()) {
            for (Element element : this.context.specs.elements.values()) {
                ArrayList<Move> moreMoves = rule.getMatchingMoves(element, this.context.specs, this.context);
                if (moreMoves == null) continue;
                moves.addAll(moreMoves);
            }
        }
        return moves;
    }

    public HashSet<Move> possibleMoves() throws Exception {
        HashSet<Move> moves = new HashSet<Move>();
        moves.addAll(this.allPossibleMoves());
        return moves;
    }

    private int gameOver() throws Exception {
        this.context.setState(this);
        for (Map.Entry<Expr, Expr> cond : this.context.specs.terminationConditions.entrySet()) {
            Expr evalResult = cond.getKey().eval(this.context);
            if (!evalResult.isTrue()) continue;
            return cond.getValue().eval(this.context).getInt();
        }
        return -1;
    }

    public boolean moveAllowed(Move move) throws Exception {
        this.context.setState(this);
        if (!this.elementLocations.get(move.element).equals(move.from)) {
            return false;
        }
        if (this.locationElements.get(move.to) != null) {
            return false;
        }
        for (GameRule rule : this.context.specs.rules.values()) {
            if (!rule.matches(move, this.context)) continue;
            return true;
        }
        return false;
    }

    public void performMove(Move move) throws Exception {
        this.context.setState(this);
        GameRule bestRule = this.findBestRule(move);
        if (bestRule == null) {
            throw new Exception("Trying to perform a move that is not legal in this state " + move);
        }
        bestRule.addScores(this.context);
        this.moveElement(move, this.context.specs);
        bestRule.performAction(this.context);
        this.updateScores(this.context);
        this.winner = this.gameOver();
        this.modified = true;
    }

    private void updateScores(Context context) throws Exception {
        for (GameScoring scoring : context.specs.scorings) {
            if (!scoring.situation.eval(context).isTrue()) continue;
            for (int i = 0; i < scoring.players.size(); ++i) {
                int player = scoring.players.get(i).eval(context).getInt();
                int amount = scoring.amounts.get(i).eval(context).getInt();
                int n = player - 1;
                context.getState().playerScores[n] = context.getState().playerScores[n] + amount;
            }
        }
    }

    private GameRule findBestRule(Move move) throws Exception {
        int maximumScoreGained = Integer.MIN_VALUE;
        GameRule bestRule = null;
        for (GameRule rule : this.context.specs.rules.values()) {
            if (!rule.matches(move, this.context)) continue;
            if (bestRule == null) {
                bestRule = rule;
            }
            for (int i = 0; i < rule.scorePlayer.size(); ++i) {
                int score;
                if (rule.scorePlayer.get(i).eval(this.context).getInt() != this.currentPlayer || (score = rule.scoreAmount.get(i).eval(this.context).getInt()) <= maximumScoreGained) continue;
                maximumScoreGained = score;
                bestRule = rule;
            }
        }
        return bestRule;
    }

    public void moveElement(Move move, GameSpecification specs) {
        this.elementLocations.put(move.element, move.to);
        this.locationElements.put(move.from, null);
        this.locationElements.put(move.to, move.element);
        this.modified = true;
    }
}

