/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine;

import s3games.engine.GameSpecification;
import s3games.engine.LocationType;

public class Move {
    public final String from;
    public final String to;
    public final String element;
    private final String hashString;
    private final int hash;

    public Move(String from, String to, String element, GameSpecification specs) {
        this.from = from;
        this.to = to;
        this.element = element;
        this.hashString = this.computeHashString(specs);
        this.hash = this.hashString.hashCode();
    }

    private String computeHashString(GameSpecification specs) {
        LocationType fromType = specs.locationTypes.get(specs.locations.get((Object)this.from).type);
        LocationType toType = specs.locationTypes.get(specs.locations.get((Object)this.to).type);
        String fromHash = this.from;
        String toHash = this.to;
        String elementType = specs.elements.get((Object)this.element).type;
        String elementState = Integer.toString(specs.elements.get((Object)this.element).initialState);
        if (!fromType.relevant) {
            fromHash = fromType.name;
        }
        if (!toType.relevant) {
            toHash = toType.name;
        }
        StringBuilder s = new StringBuilder(fromHash.length() + toHash.length() + elementType.length() + elementState.length() + 6);
        s.append(fromHash);
        s.append('*');
        s.append(toHash);
        s.append('*');
        s.append(elementType);
        s.append('*');
        s.append(elementState);
        return s.toString();
    }

    public String toString() {
        return this.from + "->" + this.to + ":" + this.element;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other instanceof Move) {
            Move otherMove = (Move)other;
            if (this.hash != otherMove.hash) {
                return false;
            }
            if (this.hashString.equals(otherMove.hashString)) {
                return true;
            }
        }
        return false;
    }
}

