/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine.expr;

import java.util.ArrayList;
import s3games.engine.expr.Context;
import s3games.engine.expr.ExprParser;
import s3games.engine.expr.Expr_LIST;
import s3games.engine.expr.Expr_LOG_CONSTANT;
import s3games.engine.expr.Expr_NUM_CONSTANT;
import s3games.engine.expr.Expr_STR_CONSTANT;
import s3games.engine.expr.Lexeme;
import s3games.util.IndexedName;

public abstract class Expr {
    public Expr append(Expr expr) {
        Expr el = this;
        if (!(el instanceof Expr_LIST)) {
            el = new Expr_LIST(this);
        }
        ((Expr_LIST)el).add(expr);
        return el;
    }

    public static Expr parseExpr(String ln) throws Exception {
        ArrayList<Lexeme> lexs = Lexeme.parseLine(ln);
        return ExprParser.parseExpr(lexs);
    }

    public static operatorType getOperatorType(String op) {
        if (op.equals("==")) {
            return operatorType.EQUALS;
        }
        if (op.equals("!=")) {
            return operatorType.NOTEQUALS;
        }
        if (op.equals("<")) {
            return operatorType.LOWER;
        }
        if (op.equals("<=")) {
            return operatorType.LOWEREQUAL;
        }
        if (op.equals(">")) {
            return operatorType.GREATER;
        }
        if (op.equals(">=")) {
            return operatorType.GREATEREQUAL;
        }
        if (op.equals("+")) {
            return operatorType.PLUS;
        }
        if (op.equals("-")) {
            return operatorType.MINUS;
        }
        if (op.equals("*")) {
            return operatorType.TIMES;
        }
        if (op.equals("/")) {
            return operatorType.DIV;
        }
        if (op.equals("%")) {
            return operatorType.MOD;
        }
        if (op.equals("ABS")) {
            return operatorType.ABS;
        }
        if (op.equals("SUBSET")) {
            return operatorType.SUBSET;
        }
        if (op.equals("IN")) {
            return operatorType.ELEMENT;
        }
        if (op.equals("SETMINUS")) {
            return operatorType.SETMINUS;
        }
        if (op.equals("UNION")) {
            return operatorType.UNION;
        }
        if (op.equals("INTERSECT")) {
            return operatorType.INTERSECTION;
        }
        if (op.equals("AND")) {
            return operatorType.AND;
        }
        if (op.equals("OR")) {
            return operatorType.OR;
        }
        if (op.equals("NOT")) {
            return operatorType.NOT;
        }
        if (op.equals("=")) {
            return operatorType.ASSIGNMENT;
        }
        return operatorType.UNKNOWN;
    }

    public static internalFunction getInternalFunction(String fn) {
        if (fn.equals("IF")) {
            return internalFunction.IF;
        }
        if (fn.equals("FORALL")) {
            return internalFunction.FORALL;
        }
        if (fn.equals("FORSOME")) {
            return internalFunction.FORSOME;
        }
        if (fn.equals("LOCTYPE")) {
            return internalFunction.LOCTYPE;
        }
        if (fn.equals("ELTYPE")) {
            return internalFunction.ELTYPE;
        }
        if (fn.equals("STATE")) {
            return internalFunction.STATE;
        }
        if (fn.equals("LOCATION")) {
            return internalFunction.LOCATION;
        }
        if (fn.equals("CONTENT")) {
            return internalFunction.CONTENT;
        }
        if (fn.equals("EMPTY")) {
            return internalFunction.EMPTY;
        }
        if (fn.equals("INDEX")) {
            return internalFunction.INDEX;
        }
        if (fn.equals("INDEXA")) {
            return internalFunction.INDEXA;
        }
        if (fn.equals("UNINDEX")) {
            return internalFunction.UNINDEX;
        }
        if (fn.equals("OWNER")) {
            return internalFunction.OWNER;
        }
        if (fn.equals("PLAYER")) {
            return internalFunction.PLAYER;
        }
        if (fn.equals("SCORE")) {
            return internalFunction.SCORE;
        }
        if (fn.equals("ZINDEX")) {
            return internalFunction.ZINDEX;
        }
        if (fn.equals("MOVE")) {
            return internalFunction.MOVE;
        }
        if (fn.equals("SETOWNER")) {
            return internalFunction.SETOWNER;
        }
        if (fn.equals("SETSTATE")) {
            return internalFunction.SETSTATE;
        }
        if (fn.equals("SETZINDEX")) {
            return internalFunction.SETZINDEX;
        }
        if (fn.equals("NEXTPLAYER")) {
            return internalFunction.NEXTPLAYER;
        }
        return internalFunction.UNKNOWN;
    }

    public static Expr numExpr(int num) {
        return new Expr_NUM_CONSTANT(num);
    }

    public static Expr strExpr(String str) {
        return new Expr_STR_CONSTANT(str);
    }

    public static Expr booleanExpr(boolean b) {
        return new Expr_LOG_CONSTANT(b);
    }

    public int getInt() throws Exception {
        throw new Exception("expected numeric expression, but it's " + this + " here");
    }

    public String getStr() throws Exception {
        throw new Exception("expected string expression, but it's " + this + " here");
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean matches(String s, Context context) {
        return false;
    }

    public boolean matches(int i, Context context) {
        return false;
    }

    public boolean matches(IndexedName name, Context context) {
        return false;
    }

    public abstract Expr eval(Context var1) throws Exception;

    public boolean equals(Expr other, Context context) throws Exception {
        Expr val = this.eval(context);
        return val.equals(other, context);
    }

    public static enum internalFunction {
        IF,
        FORALL,
        FORSOME,
        LOCTYPE,
        ELTYPE,
        STATE,
        LOCATION,
        CONTENT,
        EMPTY,
        INDEX,
        INDEXA,
        UNINDEX,
        OWNER,
        PLAYER,
        SCORE,
        ZINDEX,
        MOVE,
        SETOWNER,
        SETSTATE,
        SETZINDEX,
        NEXTPLAYER,
        UNKNOWN;

    }

    public static enum operatorType {
        EQUALS,
        NOTEQUALS,
        LOWER,
        LOWEREQUAL,
        GREATER,
        GREATEREQUAL,
        PLUS,
        MINUS,
        TIMES,
        DIV,
        MOD,
        ABS,
        SUBSET,
        ELEMENT,
        SETMINUS,
        UNION,
        INTERSECTION,
        AND,
        OR,
        NOT,
        ASSIGNMENT,
        UNKNOWN;

    }
}

