/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine.expr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import s3games.engine.expr.BooleanLexeme;
import s3games.engine.expr.Expr;
import s3games.engine.expr.InternalFunctionLexeme;
import s3games.engine.expr.Lexeme;
import s3games.engine.expr.NumberLexeme;
import s3games.engine.expr.OperatorLexeme;
import s3games.engine.expr.ParenthesesLexeme;
import s3games.engine.expr.SetLexeme;
import s3games.engine.expr.StringLexeme;
import s3games.engine.expr.StringWithReferencesLexeme;
import s3games.engine.expr.VariableLexeme;
import s3games.engine.expr.WordLexeme;

class LexemeParser {
    private static final String allSeparators = "=!<=>+-*/% \t(),\"$";
    private ArrayList<String> ln;
    private LinkedList<Character> stack;

    LexemeParser() {
    }

    ArrayList<Lexeme> parseLine(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line, allSeparators, true);
        this.ln = new ArrayList();
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            this.ln.add(token);
        }
        this.stack = new LinkedList();
        return this.parseLn();
    }

    private char closingBracketFor(String bracket) {
        if (bracket.charAt(0) == '(') {
            return ')';
        }
        return '}';
    }

    private ArrayList<Lexeme> parseLn() throws Exception {
        ArrayList<Lexeme> acc = new ArrayList<Lexeme>();
        while (!this.ln.isEmpty()) {
            String token = this.ln.get(0);
            this.ln.remove(0);
            if (token.equals("$")) {
                if (this.ln.isEmpty()) {
                    throw new Exception("$ without name");
                }
                String varName = this.ln.get(0);
                this.ln.remove(0);
                acc.add(new VariableLexeme(varName));
                continue;
            }
            if (token.equals("!")) {
                if (this.ln.isEmpty()) {
                    throw new Exception("unexpected terminating !");
                }
                token = token + this.ln.get(0);
                this.ln.remove(0);
            } else if (token.equals("<") || token.equals(">") || token.equals("=")) {
                if (this.ln.isEmpty()) {
                    throw new Exception("unexpected terminating " + token);
                }
                if (this.ln.get(0).equals("=")) {
                    token = token + "=";
                    this.ln.remove(0);
                }
            }
            Expr.operatorType opType = Expr.getOperatorType(token);
            if (opType != Expr.operatorType.UNKNOWN) {
                acc.add(new OperatorLexeme(opType));
                continue;
            }
            Expr.internalFunction fn = Expr.getInternalFunction(token);
            if (fn != Expr.internalFunction.UNKNOWN) {
                acc.add(new InternalFunctionLexeme(fn));
                continue;
            }
            if (token.equals("\"")) {
                TreeMap<Integer, String> vars = new TreeMap<Integer, String>();
                StringBuilder sb = new StringBuilder();
                while (true) {
                    if (this.ln.isEmpty()) {
                        throw new Exception("parsing expression: malformed string");
                    }
                    token = this.ln.get(0);
                    this.ln.remove(0);
                    if (token.equals("\"")) break;
                    if (token.equals("$")) {
                        if (this.ln.isEmpty()) {
                            throw new Exception("parsing expression: malformed var ref. inside string");
                        }
                        vars.put(sb.length(), this.ln.get(0));
                        this.ln.remove(0);
                        continue;
                    }
                    sb.append(token);
                }
                if (vars.size() > 0) {
                    acc.add(new StringWithReferencesLexeme(sb.toString(), vars));
                    continue;
                }
                acc.add(new StringLexeme(sb.toString()));
                continue;
            }
            if (token.toLowerCase().equals("true")) {
                acc.add(new BooleanLexeme(true));
                continue;
            }
            if (token.toLowerCase().equals("false")) {
                acc.add(new BooleanLexeme(false));
                continue;
            }
            if (Character.isDigit(token.charAt(0))) {
                acc.add(new NumberLexeme(Integer.parseInt(token)));
                continue;
            }
            if (token.equals("{") || token.equals("(")) {
                int previousStackSize = this.stack.size();
                this.stack.push(Character.valueOf(this.closingBracketFor(token)));
                ArrayList<Lexeme> elems = new ArrayList<Lexeme>();
                while (this.stack.size() > previousStackSize) {
                    ArrayList<Lexeme> elems1 = this.parseLn();
                    if (this.stack.size() > previousStackSize) {
                        this.stack.pop();
                    }
                    elems.add(new ParenthesesLexeme(elems1));
                }
                if (token.equals("{")) {
                    acc.add(new SetLexeme(elems));
                    continue;
                }
                acc.add(new ParenthesesLexeme(elems));
                continue;
            }
            if (token.equals(",")) {
                if (this.stack.isEmpty()) {
                    throw new Exception("misplaced comma");
                }
                this.stack.push(Character.valueOf(','));
                return acc;
            }
            if (token.equals("}") || token.equals(")")) {
                if (!this.stack.isEmpty() && this.stack.pop().equals(Character.valueOf(token.charAt(0)))) {
                    return acc;
                }
                throw new Exception("misplaced terminating bracket " + token);
            }
            acc.add(new WordLexeme(token));
        }
        if (!this.stack.isEmpty()) {
            throw new Exception("missing terminating bracket " + this.stack.pop());
        }
        return acc;
    }
}

