/*
 * Decompiled with CFR 0.152.
 */
package s3games.gui;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Map;
import s3games.engine.Element;
import s3games.engine.ElementType;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Location;
import s3games.gui.ImageWithHotSpot;

public class BoardCanvas
extends Canvas {
    public GameSpecification gameSpec = null;
    GameState gState = null;
    Image bgImage;
    ImageWithHotSpot img;
    private BufferedImage buffImg;
    String selectedElementName;

    public void setGame(GameSpecification gs) {
        this.bgImage = Toolkit.getDefaultToolkit().getImage(gs.boardBackgroundFileName);
        this.gState = null;
        this.buffImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.selectedElementName = null;
        this.gameSpec = gs;
    }

    public void setState(GameState egs) {
        this.gState = egs;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.gameSpec != null) {
            Graphics bg = this.buffImg.getGraphics();
            bg.clearRect(0, 0, this.getWidth(), this.getHeight());
            bg.drawImage(this.bgImage, 0, 0, this.getWidth(), this.getHeight(), this);
            if (this.gState != null) {
                Map<String, String> elements = this.gState.elementLocations;
                for (Map.Entry<String, Location> entry : this.gameSpec.locations.entrySet()) {
                    Location loc = entry.getValue();
                    this.img = this.gameSpec.locationTypes.get((Object)loc.type).image;
                    int xCorner = loc.point.x - this.img.hotSpot.x - this.img.image.getWidth(this) / 2;
                    int yCorner = loc.point.y - this.img.hotSpot.y - this.img.image.getHeight(this) / 2;
                    bg.drawImage(this.img.image, xCorner, yCorner, this);
                }
                for (Map.Entry<String, Object> entry : elements.entrySet()) {
                    String elementName = entry.getKey();
                    Element element = this.gameSpec.elements.get(elementName);
                    ElementType elType = this.gameSpec.elementTypes.get(element.type);
                    Integer actualState = this.gState.elementStates.get(elementName);
                    this.img = elType.images[actualState - 1];
                    String elementLoc = (String)entry.getValue();
                    Location loc = this.gameSpec.locations.get(elementLoc);
                    int xCorner = loc.point.x - this.img.hotSpot.x - this.img.image.getWidth(this) / 2;
                    int yCorner = loc.point.y - this.img.hotSpot.y - this.img.image.getHeight(this) / 2;
                    bg.drawImage(this.img.image, xCorner, yCorner, this);
                }
            }
            this.highlightSelected(bg);
            g.drawImage(this.buffImg, 0, 0, this);
        }
    }

    private void highlightSelected(Graphics g) {
        if (this.selectedElementName != null) {
            String elementLoc = this.gState.elementLocations.get(this.selectedElementName);
            Location loc = this.gameSpec.locations.get(elementLoc);
            this.gameSpec.locationTypes.get((Object)loc.type).shape.paintShape(g, loc.point);
        }
    }

    public void setSelectedElement(String name) {
        this.selectedElementName = name;
        this.repaint();
    }
}

