/*
 * Decompiled with CFR 0.152.
 */
package s3games.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import s3games.gui.ControlWindow;
import s3games.robot.Robot;

public class RobotWindow
extends ControlWindow
implements ActionListener {
    Robot robot;
    JButton goButton;
    JButton clearButton;
    JButton testButton;
    JButton allLocationsButton;
    JButton initButton;
    JButton pauseButton;
    JButton controlButton;
    boolean ourTurn;

    public RobotWindow(Robot robot) {
        super("Robot control panel");
        this.robot = robot;
        this.ourTurn = false;
    }

    @Override
    protected void addButtonsToPanel(JPanel panel) {
        this.goButton = new JButton("Perform move");
        panel.add(this.goButton);
        this.clearButton = new JButton("Clear");
        panel.add(this.clearButton);
        this.testButton = new JButton("Test");
        panel.add(this.testButton);
        this.allLocationsButton = new JButton("Show all locations");
        panel.add(this.allLocationsButton);
        this.initButton = new JButton("Init");
        panel.add(this.initButton);
        this.pauseButton = new JButton("Pause");
        panel.add(this.pauseButton);
        this.controlButton = new JButton("Control");
        panel.add(this.controlButton);
        this.goButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.testButton.addActionListener(this);
        this.allLocationsButton.addActionListener(this);
        this.initButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.controlButton.addActionListener(this);
    }

    public void moving(boolean b) {
        this.ourTurn = b;
        this.goButton.setEnabled(this.ourTurn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.goButton) {
            try {
                this.robot.performMove();
            }
            catch (Exception ex) {
                this.addMessage("Robot could not perform a move: " + ex.getMessage());
            }
        } else if (e.getSource() == this.clearButton) {
            this.out.setText("");
        } else if (e.getSource() == this.testButton) {
            this.robot.doTest();
        } else if (e.getSource() == this.allLocationsButton) {
            this.robot.allLocationsDemo();
        } else if (e.getSource() == this.initButton) {
            this.robot.initArm();
        } else if (e.getSource() == this.pauseButton) {
            this.robot.pause();
        } else if (e.getSource() == this.controlButton) {
            this.robot.control();
        }
    }

    @Override
    public void close() {
        super.close();
        this.robot = null;
    }
}

