/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.PriorityQueue;
import s3games.ai.Heuristic;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.Player;

public class AStarPlayer
extends Player {
    private GameSpecification specs;
    private PriorityQueue<Node> open;
    private HashSet<GameState> visited;
    private Heuristic heuristic;

    public AStarPlayer(GameSpecification specs, Heuristic heuristic) {
        this.specs = specs;
        this.heuristic = heuristic;
    }

    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.open = new PriorityQueue();
        this.visited = new HashSet();
        this.visited.add(state);
        this.open.add(new Node(null, null, state, this.heuristic.heuristic(state, this.number)));
        while (this.open.size() > 0) {
            Node actualNode = this.open.poll();
            GameState activeState = actualNode.gs;
            HashSet<Move> possibleMoves = activeState.possibleMoves();
            for (Move mv : possibleMoves) {
                GameState gs = activeState.getCopy();
                gs.performMove(mv);
                if (this.visited.contains(gs)) continue;
                this.visited.add(gs);
                if (gs.winner == this.number) {
                    if (actualNode.previous == null) {
                        return mv;
                    }
                    while (actualNode.previous.previous != null) {
                        actualNode = actualNode.previous;
                    }
                    return actualNode.moveToThisState;
                }
                if (gs.winner != -1) continue;
                this.open.add(new Node(actualNode, mv, gs, this.heuristic.heuristic(gs, this.number)));
            }
        }
        return allowedMoves.iterator().next();
    }

    class Node
    implements Comparable {
        Move moveToThisState;
        GameState gs;
        Node previous;
        double distanceFromRoot;
        double estimatedDistance;

        Node(Node p, Move m, GameState g, double d) {
            this.moveToThisState = m;
            this.previous = p;
            this.gs = g;
            this.distanceFromRoot = p != null ? p.distanceFromRoot + 1.0 : 0.0;
            this.estimatedDistance = d;
        }

        public double getEstimation() {
            return this.distanceFromRoot + this.estimatedDistance;
        }

        public int compareTo(Object o) {
            Node n = (Node)o;
            if (this.getEstimation() > n.getEstimation()) {
                return 1;
            }
            return this.getEstimation() == n.getEstimation() ? 0 : -1;
        }
    }
}

