/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.Player;

public class BreadthFirstSearchPlayer
extends Player {
    private Queue<Node> open;
    private HashSet<GameState> visited;

    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.open = new LinkedList<Node>();
        this.visited = new HashSet();
        this.visited.add(state);
        this.open.add(new Node(null, null, state));
        while (this.open.size() > 0) {
            Node actualNode = this.open.poll();
            GameState activeState = actualNode.gs;
            HashSet<Move> possibleMoves = activeState.possibleMoves();
            for (Move mv : possibleMoves) {
                GameState gs = activeState.getCopy();
                gs.performMove(mv);
                if (this.visited.contains(gs)) continue;
                this.visited.add(gs);
                if (gs.winner == this.number) {
                    if (actualNode.previous == null) {
                        return mv;
                    }
                    while (actualNode.previous.previous != null) {
                        actualNode = actualNode.previous;
                    }
                    return actualNode.moveToThisState;
                }
                if (gs.winner != -1) continue;
                this.open.add(new Node(actualNode, mv, gs));
            }
        }
        return allowedMoves.iterator().next();
    }

    class Node {
        Move moveToThisState;
        GameState gs;
        Node previous;

        Node(Node p, Move m, GameState g) {
            this.moveToThisState = m;
            this.previous = p;
            this.gs = g;
        }
    }
}

