/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import s3games.engine.Element;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Location;
import s3games.engine.Move;
import s3games.player.Player;
import s3games.robot.Camera;

public class CameraPlayer
extends Player {
    GameSpecification specs;
    Camera camera;

    public CameraPlayer(GameSpecification specs, Camera camera) {
        this.specs = specs;
        this.camera = camera;
    }

    @Override
    public boolean isComputer() {
        return false;
    }

    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) {
        ArrayList<Camera.DetectedObject> objs;
        Move move;
        while ((move = this.determineUserMove(state, objs = this.camera.waitForUserMove())) == null) {
        }
        return move;
    }

    private Move determineUserMove(GameState state, ArrayList<Camera.DetectedObject> objs) {
        String movedFrom = null;
        String movedTo = null;
        Camera.DetectedObject objectMovedTo = null;
        HashSet<String> formerlyOccupiedLocations = new HashSet<String>();
        for (Map.Entry<String, String> loel : state.locationElements.entrySet()) {
            if (!this.specs.locations.get((Object)loel.getKey()).relevant || loel.getValue() == null) continue;
            formerlyOccupiedLocations.add(loel.getKey());
        }
        for (Camera.DetectedObject obj : objs) {
            Location loc = this.specs.findClosestCameraLocation(obj.x, obj.y);
            String expectedElement = state.locationElements.get(loc.name.fullName);
            if (expectedElement == null) {
                if (movedTo != null) {
                    this.camera.msgToUser("It seems you have moved more than one element at a time. You can only move exactly one stone at a time. Try again.");
                    return null;
                }
                movedTo = loc.name.fullName;
                objectMovedTo = obj;
                continue;
            }
            formerlyOccupiedLocations.remove(loc.name.fullName);
            Element expElement = this.specs.elements.get(expectedElement);
            if (expElement.type.equals(obj.type) && state.elementStates.get(expectedElement) == obj.state) continue;
            this.camera.msgToUser("At some place the element has changed. You can only move exactly one stone at a time. Try again.");
            return null;
        }
        if (movedTo == null) {
            this.camera.msgToUser("I did not find any formerly free location having a stone now. You can only move exactly one stone at a time. Try again.");
            return null;
        }
        if (formerlyOccupiedLocations.isEmpty()) {
            for (Location loc : this.specs.locations.values()) {
                String elName;
                if (loc.relevant || (elName = state.locationElements.get(loc.name.fullName)) == null) continue;
                Element element = this.specs.elements.get(elName);
                if (!element.type.equals(objectMovedTo.type) || state.elementStates.get(elName) != objectMovedTo.state) continue;
                movedFrom = loc.name.fullName;
            }
        }
        if (formerlyOccupiedLocations.size() != 1 && movedFrom == null) {
            this.camera.msgToUser("I did not find any formerly occupied location being free now. You can only move exactly one stone at a time. Try again.");
            return null;
        }
        if (movedFrom == null) {
            movedFrom = (String)formerlyOccupiedLocations.iterator().next();
        }
        String elem = state.locationElements.get(movedFrom);
        return new Move(movedFrom, movedTo, elem, this.specs);
    }
}

