/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashSet;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.Player;

public class DepthFirstSearchPlayer
extends Player {
    private ArrayList<Node> open;
    private HashSet<GameState> visited;
    private HashSet<GameState> history = new HashSet();

    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.open = new ArrayList();
        this.visited = new HashSet();
        this.visited.addAll(this.history);
        this.history.add(state.getCopy());
        this.visited.add(state);
        this.open.add(new Node(null, null, state));
        while (this.open.size() > 0) {
            Node actualNode = this.open.get(this.open.size() - 1);
            GameState activeState = actualNode.gs;
            this.open.remove(this.open.size() - 1);
            HashSet<Move> possibleMoves = activeState.possibleMoves();
            for (Move mv : possibleMoves) {
                GameState gs = activeState.getCopy();
                gs.performMove(mv);
                if (this.visited.contains(gs) || this.history.contains(gs)) continue;
                this.visited.add(gs);
                if (gs.winner == this.number) {
                    if (actualNode.previous == null) {
                        return mv;
                    }
                    while (actualNode.previous.previous != null) {
                        actualNode = actualNode.previous;
                    }
                    return actualNode.moveToThisState;
                }
                if (gs.winner != -1) continue;
                this.open.add(new Node(actualNode, mv, gs));
            }
        }
        return allowedMoves.iterator().next();
    }

    class Node {
        Move moveToThisState;
        GameState gs;
        Node previous;

        Node(Node p, Move m, GameState g) {
            this.moveToThisState = m;
            this.previous = p;
            this.gs = g;
        }
    }
}

