/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import s3games.ai.Heuristic;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.Player;

public class MiniMaxPlayer
extends Player {
    public static double mmRatio = 1.0;
    private Random randomGenerator;
    Heuristic heuristic;
    GameSpecification specs;
    LinkedList<Leaf> leaves;
    PriorityQueue<Node> modified;
    long nodesOpened;

    public Node newNode(Node previous, GameState gs) throws Exception {
        NodeType type = NodeType.MIN;
        if (gs.currentPlayer == this.number) {
            type = NodeType.MAX;
        }
        double val = type == NodeType.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        int depth = 1;
        if (previous != null) {
            depth = previous.depth + 1;
        }
        Node node = new Node(previous, val, type, depth);
        node.open(gs);
        return node;
    }

    public MiniMaxPlayer(GameSpecification specs, Heuristic heuristic) {
        this.specs = specs;
        this.heuristic = heuristic;
        this.randomGenerator = new Random();
    }

    double valueOfWinner(int winner, int depth) {
        double val = Double.NaN;
        if (winner == this.number) {
            val = 1.0;
        } else if (winner == 0) {
            val = 0.0;
        } else if (winner > 0) {
            val = -1.0;
        } else {
            return val;
        }
        return val *= Math.pow(0.99, depth);
    }

    public HashMap<Move, GameState> expand(GameState state, HashSet<Move> moves, double ratio) throws Exception {
        if (moves.isEmpty()) {
            return new HashMap<Move, GameState>();
        }
        HashMap<Move, GameState> expanded = new HashMap<Move, GameState>();
        int countExpanded = 0;
        for (Move mv : moves) {
            if (!(this.randomGenerator.nextDouble() < ratio)) continue;
            GameState newState = state.getCopy();
            newState.performMove(mv);
            expanded.put(mv, newState);
            ++countExpanded;
        }
        if (countExpanded == 0) {
            int selected = this.randomGenerator.nextInt(moves.size());
            Iterator<Move> it = moves.iterator();
            while (selected-- > 0) {
                it.next();
            }
            Move mv = it.next();
            GameState newState = state.getCopy();
            newState.performMove(mv);
            expanded.put(mv, newState);
        }
        return expanded;
    }

    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) throws Exception {
        Leaf lf;
        this.startMove();
        this.nodesOpened = 0L;
        HashSet<Move> possibleMoves = new HashSet<Move>(allowedMoves);
        if (possibleMoves.size() == 1) {
            return allowedMoves.get(0);
        }
        HashMap<Move, Node> topMoves = new HashMap<Move, Node>();
        HashMap<Move, GameState> newStates = this.expand(state, possibleMoves, 1.0);
        this.modified = new PriorityQueue();
        this.leaves = new LinkedList();
        for (Map.Entry<Move, GameState> mv : newStates.entrySet()) {
            topMoves.put(mv.getKey(), this.newNode(null, mv.getValue()));
        }
        while (this.ratioTimeLeft() > 0.0 && !this.leaves.isEmpty()) {
            lf = this.leaves.poll();
            if (lf.gs.winner >= 0) {
                lf.previous.update(this.valueOfWinner(lf.gs.winner, lf.previous.depth + 1));
                continue;
            }
            this.newNode(lf.previous, lf.gs);
        }
        while (!this.leaves.isEmpty()) {
            lf = this.leaves.poll();
            double val = this.valueOfWinner(lf.gs.winner, lf.previous.depth + 1);
            if (Double.isNaN(val)) {
                val = this.heuristic.heuristic(lf.gs, this.number);
            }
            lf.previous.update(val);
        }
        while (!this.modified.isEmpty()) {
            Node node = this.modified.poll();
            if (node.previous == null) continue;
            node.previous.update(node.value);
        }
        double max = Double.NEGATIVE_INFINITY;
        Move bestMove = null;
        for (Map.Entry mv : topMoves.entrySet()) {
            double val = ((Node)mv.getValue()).value;
            System.out.println(mv.getKey() + ": " + val);
            if (!(val > max)) continue;
            max = val;
            bestMove = (Move)mv.getKey();
        }
        System.out.println("Minimax - total nodes: " + this.nodesOpened);
        return bestMove;
    }

    public class Leaf {
        Node previous;
        GameState gs;

        public Leaf(GameState gs, Node previous) {
            this.gs = gs;
            this.previous = previous;
        }
    }

    public class Node
    implements Comparable {
        Node previous;
        double value;
        NodeType type;
        int depth;

        Node(Node previous, double value, NodeType type, int depth) {
            this.previous = previous;
            this.value = value;
            this.type = type;
            this.depth = depth;
        }

        void open(GameState state) throws Exception {
            if (state.winner >= 0) {
                this.value = MiniMaxPlayer.this.valueOfWinner(state.winner, this.depth);
            } else {
                double ratio = state.currentPlayer == MiniMaxPlayer.this.number ? mmRatio : 1.0;
                HashMap<Move, GameState> newStates = MiniMaxPlayer.this.expand(state, state.possibleMoves(), ratio);
                if (newStates.isEmpty()) {
                    this.value = 0.0;
                } else {
                    for (GameState gs : newStates.values()) {
                        MiniMaxPlayer.this.leaves.add(new Leaf(gs, this));
                    }
                    MiniMaxPlayer.this.nodesOpened += (long)newStates.size();
                    return;
                }
            }
            if (this.previous != null) {
                this.previous.update(this.value);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void update(double val) {
            if (this.type == NodeType.MAX) {
                if (!(val > this.value)) return;
                this.value = val;
            } else {
                if (!(val < this.value)) return;
                this.value = val;
            }
            MiniMaxPlayer.this.modified.add(this);
        }

        public int compareTo(Object o) {
            Node other = (Node)o;
            if (this.depth > other.depth) {
                return -1;
            }
            if (this.depth < other.depth) {
                return 1;
            }
            return 0;
        }
    }

    public static enum NodeType {
        MIN,
        MAX;

    }
}

