#include"constants.h"
//#include"tests.h"
#include"history.h"
#include<fstream>
using namespace std;

char bases[] = {'A', 'C', 'G', 'T'};
int debuging = 0;

string f_params, f_atoms, f_hist, p_align, f_output, f_result, f_orig;

string next_line(istream& is){ //{{{
    string line;
    do {
        getline(is, line);
    } while (line[0] == '#');
    return line;
} //}}}

void cleanup(map<vi, double>& M, double threshold, double multiply = 1.0){ //{{{
    vector<pair<vi, double>> V;
    for(auto x : M) {
        x.second*=multiply;
        if (x.second > threshold) V.push_back(x);
    }
    M.clear();
    M.insert(V.begin(), V.end());
} //}}}

void read_intro(History* h, const string& configname, const string& testnumber){ //{{{
    ifstream fc;
    fc.open("configs/"+configname + ".config");
    mustbe(fc.is_open(), "can't open config file: configs/"+configname+".config");
    f_params = next_line(fc);
    f_atoms = next_line(fc)+testnumber+".atoms";
    p_align = next_line(fc)+testnumber;
    f_hist = next_line(fc)+testnumber+".nhistory";
    f_output = next_line(fc)+configname+"-"+testnumber;
    f_result = f_output+".history";
    f_orig = f_output+".orig";
    f_output += ".samples";
    h->scoring_length = stoi(next_line(fc));
    h->scoring_similar= stoi(next_line(fc));
    h->scoring_continue = stoi(next_line(fc));
    h->scoring_boundary = stoi(next_line(fc));
    h->scoring_oldhistory = stoi(next_line(fc));
    h->scoring_nicerest = stoi(next_line(fc));
    h->scoring_divisor = stoi(next_line(fc));
    h->felsenstein_on = stoi(next_line(fc));
    
    ifstream in;
    in.open(f_params, ifstream::in);
    mustbe(in.is_open(), "can't open parameter file: "+f_params);
    h->read_parameters(in);
    in.close();
    in.open(f_atoms, ifstream::in);
    mustbe(in.is_open(), "can't open atoms file: "+f_atoms);
    h->read_atom_lists(in);
    in.close();
        
    for(auto atom : h->existing_atoms){
        string f_align = p_align+"/"+to_string(atom)+".aln";
        in.open(f_align, ifstream::in);
        mustbe(in.is_open(), "can't open alignment file: " + f_align);
        h->read_atom_alignments(in, atom);
        in.close();
    }
} //}}}

map<string, Event*> bestev;
multiset<double> best10;
Number bestlike = logNumber(-1e15), like = logNumber(-1e15),lastlike = logNumber(-1e15);

void reset_bestlike(History* h, bool save){
    if (save){
        best10.insert(like.data);
    }
    h->old_events.clear(); 
    h->old_seqences.clear(); 
    like = logNumber(-1e15);
    lastlike = logNumber(-1e15);
}

int main(int argc, char **argv){
    random_init();
    if (argc != 4) {
        cerr << "Usage: " << argv[0] << " config-number test-number iterations " <<  endl;
        return 1;
    }
    int iterations = stoi(string(argv[3]));

    History* h = new History();
    read_intro(h, argv[1], argv[2]);
    
    ifstream in;
    in.open(f_hist, ifstream::in);
    if(in.is_open()){
        h->read_events(in);
        in.close();
        h->build_trees();
        h->write_events(cout);
        Number lik = h->likelihood_all();
        Number fulllik = h->likelihood_all(true);

        cout << "orig lik: " << lik.data << endl;
        cout << "full: " << fulllik.data << endl;

        ofstream orig (f_orig, ofstream::out);
        orig << "Original likelihood: " << lik.data << " " << fulllik.data << endl;
        h->write_events(orig);
        orig.close();
        h->clear_events();
    }else{
        cout << "Original history is unknown" << endl;
    }

    ofstream output (f_output, ofstream::out);
    mustbe(output.is_open(), "can't open output file: "+f_output);
   

    double sum = 0; int cnt = 0;
    int block = iterations/5 + (iterations<5);
    For(ite, iterations){
        if (ite%block == 0) reset_bestlike(h, ite>0);
        h->compute_events();
        h->build_trees();
        Number lik = h->likelihood_all();
        output << "New sample with likelihood: " << lik.data << endl;
        h->write_events(output);
        output << endl;        

        cout << "lik: " << lik.data;
        sum+=lik.data; cnt++;
        if (lastlike < lik){
            cout << "    !! novy !!";
            if (h->scoring_oldhistory){
                cleanup(h->old_events, 0.1, 0.6);
                cleanup(h->old_seqences, 0.1, 0.6);
                for(auto ev : h->events) h->add_to_old(ev.second,1+
                        max(lik.data,bestlike.data)/lik.data);
                for(auto ev : bestev) h->add_to_old(ev.second,0.1);
            }
        }
        cleanup(h->old_events, 0.05, 0.9);
        cleanup(h->old_seqences, 0.05, 0.9);
        lastlike = lik;
        cout << endl;

        like = max(like, lik);
        if (bestlike<lik) {
            bestlike = lik;
            for(auto ev : bestev) delete ev.second;
            bestev.clear();
            bestev = h->events;
            h->events.clear(); // toto je nutne tu mat
            h->clear_events();
        }else{
            h->clear_events();
        }
    }
    output.close();
    if (iterations%block == 0) reset_bestlike(h, true);
    
    cout << "Best found history: " << bestlike.data << endl;
    
    h->events = bestev;
    h->write_events(cout);
    h->trust_me();
    h->build_trees();
    Number lik = h->likelihood_all();
    Number fulllik = h->likelihood_all(true);
    
    cout << "avge lik: " << sum/cnt << endl;
    sum = 0;  for(auto x : best10) sum+=x;
    cout << "av10 lik: " << sum/SIZE(best10) << endl;
    cout << "best lik: "; lik.print();
    cout << "total: "; fulllik.print();

    ofstream result (f_result);
    mustbe(result.is_open(), "can't open output file: "+f_result);
    result << "Best likelihood: " << lik.data << " " << fulllik.data << endl;
    h->write_events(result);
    result.close();
    h->clear_events();
    delete h;
}
