#include"number.h"

Number::Number(){
    data = 0.0;
}

Number::Number(double value){
    data = log(value);
}
Number logNumber(double _data){
    Number n;
    n.data = _data;
    return n;
}

void Number::print(FILE* f){
    fprintf(f,"%.12lf\n", this->data);
}

void Number::print_double(FILE* f){
    fprintf(f,"%.20lf\n", exp(this->data));
}

Number& Number::operator*=(const Number& n){
    data += n.data;
    return *this;
}

bool operator<(const Number& n1, const Number& n2){
    return (n1.data < n2.data);
}

Number operator*(const Number& n1, const Number& n2){
    return logNumber(n1.data + n2.data);
}

Number operator/(const Number& n1, const Number& n2){
    return logNumber(n1.data - n2.data);
}

