#ifndef mam_cislo
#define mam_cislo

#include "hlavicka.h"
using namespace std;


Cislo::Cislo(int x){
  if(x!=0){
    nula=false;
    hodnota=log(x);}
  else{ nula=true;
  hodnota=0;}
}

Cislo::Cislo(long x){
  if(x!=0){
    nula=false;
    hodnota=log(x);}
  else{ nula=true;
  hodnota=0;}
  //hodnota=x;
}


Cislo::Cislo(double x){
if(x!=0.0){
    nula=false;
    hodnota=log(x);}
  else{ nula=true;
  hodnota=0;}
//hodnota=x;
}
Cislo::Cislo(){
  nula=true;
  hodnota=0;

}

Cislo::Cislo(const Cislo& arg):
nula(arg.nula),
hodnota(arg.hodnota){};

Cislo::Cislo(const Cislo* arg):
nula(arg->nula),
hodnota(arg->hodnota){};

void Cislo::nastav(const double tato){
  hodnota=tato;
if(false){ nula=true; }else{ nula=false;}
}

double Cislo::daj_hod() const {
return hodnota;
}

double Cislo::normal() const{
  if(nula) return 0;
  return exp(hodnota);
  //return hodnota;
}

bool Cislo::som_nula() const {
  return nula;
  //return false;
}
Cislo::~Cislo(){}

bool operator> (const Cislo c1, const Cislo c2) {// TODO pozriet porovnavanie
  double pom1=c1.daj_hod();
  double pom2=c2.daj_hod();
  if (c1.som_nula()){
    return c2.som_nula();}
  else{
    if(c2.som_nula()) return true;
    return pom1>pom2;
  }
  return c1.daj_hod()>c2.daj_hod();
}

bool operator< (const Cislo c1, const Cislo c2) {
  double pom1=c1.daj_hod();
  double pom2=c2.daj_hod();
  if (c1.som_nula()){
    return c2.som_nula()!=true;}
  else{
    if(c2.som_nula()) return false;
    return pom1<pom2;
  }
  //return c1.daj_hod()<c2.daj_hod();
}



Cislo operator* (const Cislo c1, const Cislo c2){
  double pom1=c1.daj_hod();
  double pom2=c2.daj_hod();
 
  Cislo v;
  if(c1.som_nula()||c2.som_nula()){ v=Cislo(0);}
  else{
  v.nastav(pom1+pom2);}
 
  return v;
  //return Cislo(c1.daj_hod()*c2.daj_hod());
}

Cislo operator/ (const Cislo c1, const Cislo c2){
  double pom1=c1.daj_hod();
  double pom2=c2.daj_hod();
  Cislo v;
  if(c1.som_nula()) v=Cislo(0); else
  v.nastav(pom1-pom2);
  return v;
 // return Cislo(c1.daj_hod()/c2.daj_hod());
}


Cislo operator+ (const Cislo c1, const Cislo c2){
  Cislo v;
//cerr << "scitavam " << c1.normal() << " " << c2.normal() << endl;  

  if(c1.som_nula()) return Cislo(c2);
  if(c2.som_nula()) return Cislo(c1);
  if(c1>c2){
    v=Cislo(Cislo(1+(c1/c2).normal())*c2);
  }
  else{
    v=Cislo(Cislo(1+(c2/c1).normal())*c1);
  }
  //cerr << "vysledok " << v.normal() << endl;
  return v;
  //return Cislo(c1.daj_hod()+c2.daj_hod());
}

Cislo Cislo::operator=(const Cislo& arg){
  this->nula=arg.nula;
  this->hodnota=arg.hodnota;
  return (*this);
}


Cislo sum(priority_queue<Cislo,vector<Cislo>, greater<Cislo> > a){
// vyberie dve najmensie scita a vlozi spat, kym neostane len jeden prvok
  Cislo p1=a.top();
  a.pop();
  while(!a.empty()){
   Cislo p2=a.top();
   a.pop();
   a.push(p2+p1);
   p1=a.top();
   a.pop();
  }
  //cerr << endl << endl;
  return p1;
};

#endif


