<?php
/**
 * @package    Well.Unireg
 * @subpackage Components
 * @link http://www.wellhome.sk
 * @license    GNU/GPL for non-commercial use
*/

// no direct access
defined( '_FEXEC' ) or die( 'Restricted access' );

//jimport('joomla.application.component.controller');

/**
 * The main Unireg Component Controller
 *
 * @package    Well.Unireg
 * @subpackage Components
 */
class UniregControllerEntry extends FController
{	
	function isMyType($mytype) {
    	$item = $this->getModel('item');    	
    	$type = $item->getType();
    	return ($type == $mytype);
	}

	function __construct() {
		parent::__construct();

    	//Maps addCategory to editCategory
    	$this->registerTask( 'addentry'  ,     'editentry' );
	}
	
	/**
     * Method to display the view
     *
     * @access    public
     */
    function display()
    {
    	if (!$this->isMyType('entry')) {
			$link = 'index.php?option=com_unireg'; 
			$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
    		return;
    	}
    	
		FRequest::setVar( 'view', 'entry' );    	    	
       	parent::display();
        
    }
	
	function editentry() {
    	if ( FRequest::getInt('iid') > 0 )
			if (!$this->isMyType('entry')) {
				$link = 'index.php?option=com_unireg'; 
				$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
	    		return;
    	}
    	
		FRequest::setVar( 'view', 'entry' );
    	FRequest::setVar( 'layout', 'form'  );
    	    	
		parent::display();
	}
	
	function save() {
		$model = $this->getModel('entry');

		if (FRequest::getWord('cancel') != 'Cancel') {
		    if ($model->store()) {
		        $msg = FText::_( 'entry Saved!' );
		    } else {
		        $msg = FText::_( 'Error Saving entry' );
		    }
		} else {
			$msg = FText::_( 'entry change canceled' );
		}

	    // Check the table in so it can be edited.... we are done with it anyway
	    $iid = FRequest::getInt('iid');
	    if ($iid == 0) {
	    	$iid = FRequest::getInt('pid');
	    }
	   	$link = 'index.php?option=com_unireg&iid='.$iid.'&Itemid='.FRequest::getInt('Itemid');
	    $this->setRedirect($link, $msg);		
	}
	
	function upload() {
		$file = JRequest::getVar('file1','','files','array');;
		$config = new FConfig();
		$destDir = $config->path;
		$filename = FFile::makeSafe($file['name']);
		$entry = $this->getModel('entry');
		
		while (file_exists($destDir.DS.$filename)) {
			$filename = FFile::stripExt($filename).'_1'.FFile::getExt($filename);
			$file['name'] = FFile::stripExt($file['name']).'_1.'.FFile::getExt($file['name']);
		}
		
		
		if (!FFile::upload($file['tmp_name'], $destDir.DS.$filename)) {
		    $msg = "Upload failed!";
		} else {
			if ($entry->saveFileDB(FRequest::getInt('rid'),$file['name'],$filename,$destDir,$file['type']))
			    $msg = "Upload complete!";
			else
				$msg = "Error saving new file to database";
		}
		
	    $link = 'index.php?option=com_unireg&controller=entry&task=display&iid='.FRequest::getInt('iid');
	    $this->setRedirect($link, $msg);	
		
	}
	
	function filedownload() {
		$file = $this->getModel('recfile');
		$fparams = $file->getFileParams(FRequest::getInt('fid'));
		
		/**
		 * taken from DOCMAN:
		 *  administrator > components > com_docman > classes > DOCMAN_file.class.php
		 */		
		while (@ob_end_clean());

		//header("Location: http://google.com");

		$fsize = @filesize($fparams->path.DS.$fparams->filename);
		$mod_date = date('r', filemtime( $this->path.$this->name ) );

		//$cont_dis = $inline ? 'inline' : 'attachment';
		$cont_dis = 'attachment';
		// required for IE, otherwise Content-disposition is ignored
		
		/*if(ini_get('zlib.output_compression'))  {
			ini_set('zlib.output_compression', 'Off');
		}*/

        header("Pragma: public");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Expires: 0");

        header("Content-Transfer-Encoding: binary");
		header('Content-Disposition:' . $cont_dis .';'
			. ' filename="' . $fparams->name . '";'
			. ' modification-date="' . $mod_date . '";'
			. ' size=' . $fsize .';'
			); //RFC2183
        header("Content-Type: "    . $fparams->mime );			// MIME type
        header("Content-Length: "  . $fsize);

        /*if( ! ini_get('safe_mode') ) { // set_time_limit doesn't work in safe mode
		    @set_time_limit(0);
        }*/

 		// No encoding - we aren't using compression... (RFC1945)
		//header("Content-Encoding: none");
		//header("Vary: none");

		@readfile($fparams->path.DS.$fparams->filename);
		
        //$this->readfile_chunked($this->path.$this->name);
        // The caller MUST 'die();'				
		
		/*$link = 'index.php?option=com_unireg&controller=entry&task=display&iid='.FRequest::getInt('iid');
	    $this->setRedirect($link, $msg);*/			
	}
	
	function filedelete() {
		$file = $this->getModel('recfile');
		$fparams = $file->getFileParams(FRequest::getInt('fid'));	
		
		if (FFile::delete($fparams->path.DS.$fparams->filename)){
			if ($file->delete(FRequest::getInt('fid'))) {
				$msg = 'The file was deleted successfully.';	
			} else {
				$msg = 'The file was deleted but it stayed in database.';
			}			
		} else {
			$msg = 'It was impossible to delete the file.';
		}
		
		$link = 'index.php?option=com_unireg&controller=entry&task=display&iid='
				.FRequest::getInt('iid').'&Itemid='
	    		.FRequest::getInt('Itemid');
	    $this->setRedirect($link, $msg);		
	}
	
	function deleteallfiles() {		
		
	}
	
	function showDetails() {
    	if (!$this->isMyType('entry')) {
			$link = 'index.php?option=com_unireg'; 
			$this->setRedirect($link, 'You chose an incorrect controller in the URL.');    		
    		return;
    	}

		FRequest::setVar( 'view', 'entry' );
    	FRequest::setVar( 'layout', 'details'  );
    	    	
		parent::display();
	}
}
?>